import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 100)
    # throttle - maximum analog value AI will attempt not to exceed (default 130)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 3)
    # turn - maximum analog value AI will attempt not to exceed (default 50)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)

    # 0 - Red Zone "That's where your bot will be after ten seconds with ours!"
    list.append(("Scout","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':5,'weapons':(8,9)}))
    list.append(("RED ALERT","PokerPlus",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(13,14,16,17,18)}))
    list.append(("Second Sentinel","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':3,'weapons':(18,19)}))
    list.append(("AW-Intruder!","Flipper",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(25,)}))
    list.append(("BW-Code R.E.D.","Poker",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(4,)}))
    list.append(("Guard Duty","Omni",{'invertible':False,'nose':math.pi*2,'radius':0.2,'topspeed':100,'throttle':130,'turn':40,'turnspeed':2,'weapons':(20,)}))

    # 1 - PREHISTORIC "Badder and still bloodthirsty! Or should we say "bot-thirsty"?" (<== LAME PUN ALERT)
    list.append(("Roly Poly","Rammer",{'failbot':True,'invertible':True,'failbot':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':160,'turn':130,'turnspeed':5}))
    list.append(("Saber Teeth","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':5,'weapons':(10,11,12,13)}))
    list.append(("Grog, the Resurrection","FBSPlus",{'nose':math.pi*2.25,'spinspeed':6,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':70,'turnspeed':4,'weapons':(20,21,22,23,24,25,26)}))
    list.append(("Silex 2","Poker",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Erectus","Omni",{'nose':math.pi,'radius':0.3,'range':50,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Sapiens","FBSPlus",{'invertible':False,'nose':math.pi*0.5,'radius':1.5,'spinspeed':10,'topspeed':100,'range':99,'throttle':130,'turn':60,'turnspeed':4,'weapons':(2,)}))

    # 2 - The Good Ol' Boys "Don't need nuthin' but my truck, my shotgun, my new bots, and my REVENGE!"
    list.append(("Hammerhead Shark","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Blood Runner","Omni",{'invertible':False,'nose':math.pi*2,'radius':.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(17,)}))
    list.append(("Rabid Grisly Bear","OmniMultiZone",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(22,23,24,25)}))
    list.append(("Country Farmboy","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'range':30,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(17,)}))
    list.append(("Redneck","OmniRam",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':2.5,'weapons':(6,7,8,9)}))
    list.append(("Patriot 2","Omni",{'invertible':True,'nose':math.pi,'radius':0.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1.5,'weapons':(11,)}))

    # 3 - Team Dragon "Honor - you'll see what it means after fighting our bots."
    list.append(("Ninja","VertSpinner",{'nose':math.pi,'radius':0.1,'range':3,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(4,5)}))
    list.append(("Samurai","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(9,10)}))
    list.append(("Shogun","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(13,14,15,16)}))
    list.append(("Bushi","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(15,)}))
    list.append(("Ronin","Popup",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,20)}))
    list.append(("SHW-Mikado","Omni",{'nose':math.pi,'radius':2,'range':60,'topspeed':100,'throttle':100,'turn':30,'turnspeed':2,'weapons':(55,)}))

    # 4 - BLACK STORM  "All the fear of the dark and all the force of a storm."
    list.append(("BOT-206","Omni",{'nose':math.pi,'radius':0.1,'range':50,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,)}))
    list.append(("Devil III","OmniRam",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':20,'turnspeed':1}))
    list.append(("Industrial Coal Miner","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':10,'topspeed':150,'throttle':130,'turn':60,'turnspeed':3,'weapons':(29,41,42)}))
    list.append(("Reaver","Omni",{'nose':math.pi*2,'radius':0.1,'range':30,'topspeed':100,'throttle':100,'turn':25,'turnspeed':2,'weapons':(7,)}))
    list.append(("Darkling","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':40,'turnspeed':1,'weapons':(5,6)}))
    list.append(("Black Storm 2.2","Spinner",{'nose':math.pi*0.5,'range':99,'radius':0.5,'topspeed':100,'throttle':130,'turn':100,'turnspeed':5,'weapons':(25,)}))

    # 5 - Team SPARK  "When SPARKs fly, robots die."
    list.append(("BROKE!","Popup",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,)}))
    list.append(("The Boxer's Revenge","Poker",{'failbot':True,'invertible':True,'triggers':["JabLeft","JabRight"],'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':130,'turnspeed':5,'weapons':(12,17)}))
    list.append(("CRITICAL EMERGENCY","Flipper",{'nose':math.pi,'radius':0.1,'topspeed':150,'throttle':130,'turn':60,'turnspeed':2,'weapons':(9,10,11,12)}))
    list.append(("Speed Freak","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4,'weapons':(11,12)}))
    list.append(("Explosive Material","Omni",{'nose':math.pi,'radius':0.1,'range':40,'topspeed':100,'throttle':130,'turn':30,'turnspeed':4,'weapons':(21,)}))
    list.append(("Fast'N'Furious","Poker",{'invertible':False,'spinspeed':6,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(20,22)}))

    # 6 - Spike Heads "We'd like you to meet our big metal friend..."
    list.append(("Raving M.A.D.","Rammer",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':70,'turnspeed':4}))
    list.append(("Insanity","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(5,)}))
    list.append(("Big Metal Friend","Omni",{'invertible':True,'nose':math.pi*2,'radius':1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':4,'weapons':(39,42)}))
    list.append(("Absurdity","Spinner",{'invertible':False,'range':50,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(9,10)}))
    list.append(("Feeblemind","FBS",{'invertible':True,'nose':math.pi*18/10,'radius':.3,'topspeed':30,'throttle':100,'turn':80,'turnspeed':5,'weapons':(28,)}))
    list.append(("Asylum","Omni",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':3,'weapons':(17,18)}))

    # 7 - North Polers "Literally, cold blooded killers."
    list.append(("Tip of the Iceberg","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':100,'turn':60,'turnspeed':3.5,'weapons':(14,15,16)}))
    list.append(("Iceberg","Omni",{'nose':math.pi*2,'radius':0.1,'topspeed':15,'throttle':130,'turn':60,'turnspeed':2,'weapons':(11,12,13)}))
    list.append(("SnowJob v2","Pusher",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':150,'throttle':130,'turn':60,'turnspeed':2}))
    list.append(("Frenzied Snowman","VertSpinner",{'nose':math.pi*2,'range':99,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(13,)}))
    list.append(("Hypothermia","Omni",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':3,'weapons':(19,20)}))
    list.append(("Frostbite","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(15,20)}))

    # 8 - HIGH VOLTAGE "Nothing like 10,000 VAC to keep you awake and alert."
    list.append(("FlipJack's Revenge","PokerPlus",{'nose':math.pi,'radius':0.1,'delay':20,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("SlashBack 2","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(18,19,20,21)}))
    list.append(("WIIIDE LOAD","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(29,30)}))
    list.append(("Thunderclap","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(10,)}))
    list.append(("ElectroStatic","Frenzy",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':3.5,'weapons':(33,)}))
    list.append(("Gigawatt","Pinner",{'turn':20,'turnspeed':2,'weapons':(1,)}))

    # 9 - Team HEX "We eat nuts and bolts for breakfast... and your bots for lunch !"
    list.append(("Grim Chopper","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':100,'turn':80,'turnspeed':2,'weapons':(16,)}))
    list.append(("Lock Nut v2.3","Spinner",{'nose':math.pi*1.5,'radius':0.3,'range':99,'topspeed':100,'throttle':130,'turn':70,'turnspeed':4,'weapons':(10,11,12)}))
    list.append(("Cranky Spanky","Omni",{'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(7,8,34,35,37,38,39,40)}))
    list.append(("Gearhead","Pinner",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5}))
    list.append(("Clockwork Centurion 3","FBSPlus",{'nose':math.pi*2,'range':99,'spinspeed':5,'radius':0.5,'topspeed':100,'throttle':130,'turn':80,'turnspeed':2,'weapons':(20,)}))
    list.append(("Crash Test 2","Omni",{'nose':math.pi,'range':20,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(13,14)}))

    # 10 - Team Z "Still cooler than you. Deadlier as well"
    list.append(("Berserker","Spinner",{'nose':-math.pi/2,'range':40,'radius':0.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(9,10,11)}))
    list.append(("Razorback v2","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2,'weapons':(25,)}))
    list.append(("Eye Stabber","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(18,)}))
    list.append(("Silver Star 2","Omni",{'invertible':True,'nose':math.pi,'range':4,'radius':0.1,'topspeed':100,'throttle':100,'turn':60,'turnspeed':2,'weapons':(14,15,16,17)}))
    list.append(("741","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(11,)}))
    list.append(("SHW-Blade Wave","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':120,'throttle':130,'turn':100,'turnspeed':4,'weapons':(1,2,3)}))

    # 11 - SteelYard Dawgs "Our bite is worse than our bark, but our pushing power is the worst by far."
    list.append(("Mangy Mutt","OmniRam",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Top Dog","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':40,'turnspeed':1,'weapons':(1,)}))
    list.append(("Bad Dog","OmniRam",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':40,'turnspeed':1,'weapons':(1,)}))
    list.append(("AW-Skinny Puppy","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':100,'turn':30,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("BW-FangY","OmniRam",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("SHW-Tough Dog 2","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.2,'topspeed':100,'throttle':100,'turn':50,'turnspeed':3,'weapons':(1,)}))

    # 12 - RIOT "Things are going to get even LOUDER!"
    list.append(("Civil Uprising","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':90,'topspeed':100,'throttle':130,'turn':80,'turnspeed':4,'weapons':(5,6,7,8)}))
    list.append(("Deadly VENGEANCE","Omni",{'invertible':False,'nose':math.pi,'range':50,'radius':0.3,'topspeed':100,'throttle':130,'turn':50,'turnspeed':3,'weapons':(8,9,10,11)}))
    list.append(("Velociraptor","InvertOmni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':50,'turnspeed':3,'weapons':(31,32,33,34,35,36)}))
    list.append(("Molotov","Omni",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,12)}))
    list.append(("REvolution ","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1.5,'weapons':(26,)}))
    list.append(("The Anarchist's Cookbook","Spinner",{'nose':math.pi,'range':99,'radius':1.0,'topspeed':100,'throttle':130,'turn':80,'turnspeed':2.5,'weapons':(14,)}))

    # 13 - MEGATON "KABBBBOOOOOOOOOOOMMMMM!!!!!!!!1"
    list.append(("Explosive Stinger","Poker",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':100,'turnspeed':2.5,'weapons':(9,)}))
    list.append(("Tempest","Spinner",{'nose':math.pi*2,'radius':0.5,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(18,19,20,21,26,27)}))
    list.append(("UnDeadbeat","Poker",{'nose':math.pi,'delay':20,'radius':0.1,'topspeed':100,'throttle':130,'turn':50,'turnspeed':2,'weapons':(31,)}))
    list.append(("Impact Event","Spinner",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,)}))
    list.append(("Shockwave 2","Popup",{'invertible':False,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':3.5,'weapons':(10,11)}))
    list.append(("Cataclysm 2","FBS",{'spinspeed':15,'invertible':True,'nose':math.pi*2,'radius':1.5,'topspeed':100,'throttle':130,'turn':90,'turnspeed':4,'weapons':(22,23,24)}))

    # 14 - The Scrappers "We scrap junk for a living, so your bots won't be a problem at all."
    list.append(("360 Arc Pounder","FBS",{'invertible':True,'nose':math.pi,'spinspeed':20,'radius':0.5,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(9,11)}))
    list.append(("Ripblade III","VertSpinner",{'nose':math.pi,'radius':0.5,'range':20,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(17,18,19,20,21,22,23,24,25,26,27,28)}))
    list.append(("Backyard Grinder","Omni",{'nose':math.pi*2,'range':4,'radius':0.3,'topspeed':100,'throttle':100,'turn':30,'turnspeed':2,'weapons':(33,45,46)}))
    list.append(("JunkMaker 3000","Omni",{'nose':math.pi,'invertible':False,'radius':0.1,'range':2,'topspeed':100,'throttle':100,'turn':60,'turnspeed':4,'weapons':(9,)}))
    list.append(("Scavenger","Omni",{'invertible':True,'nose':math.pi,'radius':0,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(7,8)}))
    list.append(("SHW-Scrapyard Behemoth","Spinner",{'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':100,'throttle':130,'turn':100,'turnspeed':5,'weapons':(16,)}))
	
    # 15 - BBEANS Champions "The best of BBEANS, for your worst."
    list.append(("Smashbox 2","Smashbox",{'nose':math.pi,'radius':1,'reload':8,'topspeed':18,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(20,),'sweapons':(21,),'tweapons':(22,),'qweapons':(23,)}))
    list.append(("Mako","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.2,'weapons':(25,26)}))
    list.append(("Shebeast","SwitchWep",{'invertible':True,'range':99,'nose':math.pi*2,'radius':1.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(36,37,38,39,40,41,42,51,52,53,54,55,56,57,58,59,62,63),'sweapons':(20,)}))
    list.append(("Hazardous Contraption","Omni",{'nose':math.pi,'radius':0.5,'awesomeness':["OVER 9000"],'range':50,'topspeed':100,'turn':50,'turnspeed':3,'weapons':(13,14,15,16,17,18,19,20)}))
    list.append(("Enfilad3","Omni",{'nose':math.pi,'radius':0.5,'topspeed':100,'throttle':130,'turn':50,'turnspeed':3,'weapons':(11,12,13,14,15,16)}))
    list.append(("Diarrhea Of A Madman","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':1.2,'topspeed':100,'throttle':130,'turn':75,'turnspeed':2.5,'weapons':(16,)}))
	
    # 16 - Robot Arena Reincarnated "From the forgotten graves and rusting junk we rise again!"
    list.append(("Gammaraze IV","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,20,22,36,37,40)}))
    list.append(("Topknot III","Topknot",{'invertible':False,'whip':"around",'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(29,30,31,32,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69)}))
    list.append(("ScootOrDie 2","OmniMultiZone",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(1,2,3)}))
    list.append(("Aquarius 3","Poker",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1.5,'weapons':(20,23,29)}))
    list.append(("Pon2n","Omni",{'nose':math.pi,'radius':0,'range':50,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1.5,'weapons':(39,40,42,43,47,48)}))
    list.append(("Triclops v3.0","Omni",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':130,'turnspeed':2.5,'weapons':(23,24,25)}))

    # 17 - Arthrobotics "Be warned... these bugs swat back"
    list.append(("AW-Nanowhirl","Spinner",{'nose':math.pi*2,'range':15,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(2,)}))
    list.append(("AW-Terminus","Omni",{'nose':math.pi*2,'radius':0.1,'range':15,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(17,)}))
    list.append(("BW-Microwhirl","Spinner",{'nose':math.pi*2,'range':30,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(6,9,10,11,12)}))
    list.append(("BW-True Love","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':30,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(12,13,14,15)}))
    list.append(("BW-Sheer Pressure","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4,'weapons':(10,)}))
    list.append(("BW-Robokillase","Rammer",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))

    # 18 - Stormraiders "Can your bots resist to bad weather? We think not"
    list.append(("Grey Cloud","FBS",{'invertible':True,'radius':0.2,'turn':50,'turnspeed':3,'topspeed':100,'throttle':130,'weapons':(14,15)}))
    list.append(("Djinn 2","Omni",{'nose':math.pi,'invertible':False,'radius':0.2,'range':30,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(12,13,14,15,16,17)}))
    list.append(("Mjolnir 3","Poker",{'nose':math.pi*2,'invertible':False,'radius':0.1,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Ball Lightning","Spinner",{'invertible':False,'range':99,'throttle':130,'radius':0.3,'weapons':(7,)}))
    list.append(("Zephyr","Omni",{'invertible':True,'range':10,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Century Storm","Omni",{'nose':math.pi,'invertible':True,'range':10,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
	
    # 19 - Team Despair "We have nothing to offer you but scrap, tears, toil and sweat"
    list.append(("Sad Tale","Poker",{'nose':math.pi*2,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':80,'turnspeed':3,'weapons':(6,)}))
    list.append(("Ill Omen","Poker",{'invertible':False,'radius':0.1,'throttle':130,'topspeed':99,'turn':80,'turnspeed':3,'weapons':(9,)}))
    list.append(("Agony ","Omni",{'nose':math.pi,'invertible':True,'radius':0.3,'throttle':130,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(12,13,14,15,16)}))
    list.append(("Torment 2","WhipperPlus",{'nose':math.pi,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':30,'turnspeed':2,'weapons':(1,)}))
    list.append(("Dreadweaver 2","OmniVSpinner",{'nose':math.pi,'invertible':True,'radius':0.2,'topspeed':99,'range':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,2)}))
    list.append(("Hope No More 4","Popup",{'nose':math.pi,'radius':0.5,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
	
    # 20 - Ordo Ignis "Kill it with fire!"
    list.append(("Fireside","FBS",{'nose':math.pi*0.5,'invertible':True,'radius':0.2,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(12,)}))
    list.append(("Red Drake 4","FlameOmni",{'invertible':True,'flame_range':99,'radius':0.1,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,2,3,4)}))
    list.append(("Pyrotechnic Display 3.1","Omni",{'radius':0.4,'range':50,'throttle':130,'topspeed':99,'turn':30,'turnspeed':2,'weapons':(8,)}))
    list.append(("Fireball","Omni",{'invertible':False,'radius':0.1,'range':99,'throttle':130,'topspeed':99,'turn':80,'turnspeed':4,'weapons':(24,25,26,27,29,30,31,32)}))
    list.append(("Hot Spot","FBS",{'invertible':True,'radius':0.5,'spinspeed':12,'throttle':130,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(12,)}))
    list.append(("Smelter","FlameOmni",{'nose':math.pi,'invertible':True,'flame_range':99,'radius':0.2,'throttle':130,'topspeed':99,'turn':40,'turnspeed':2.5,'weapons':(1,2,3,4)}))
	
    # 21 - In Darkest Night "You won't even see your bots losing!"
    list.append(("Creature Of Darkness","Omni",{'nose':math.pi,'invertible':False,'radius':0.1,'range':2,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(12,13,14,15,16,17)}))
    list.append(("Shadow Moon 5","Omni",{'invertible':True,'range':40,'radius':0.3,'throttle':130,'topspeed':99,'turn':60,'turnspeed':4,'weapons':(11,12,13,14)}))
    list.append(("Eclipse 3.1","Popup",{'nose':math.pi,'NoChassisTime':2,'invertible':False,'radius':0.1,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(11,12,13,14)}))
    list.append(("Erebus","OmniRam",{'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Black Dawn","Flipper",{'nose':math.pi,'invertible':False,'radius':0.1,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(13,14)}))
    list.append(("Night Horror","Omni",{'nose':math.pi,'range':50,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':40,'turnspeed':3,'weapons':(13,14)}))
	
    # 22 - Earth Element "How can you fight the strength of the Earth Element ?"
    list.append(("The Digger","Omni",{'nose':math.pi,'invertible':True,'range':10,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("Epicenter 1.1","FBS",{'nose':math.pi*2,'invertible':True,'spinspeed':12,'topspeed':100,'throttle':130,'radius':1.5,'turn':2,'turnspeed':20,'weapons':(1,2)}))
    list.append(("Rockslide","OmniRam",{'invertible':True,'radius':0,'topspeed':99,'throttle':130,'turn':40,'turnspeed':2,'weapons':(1,2,3,4)}))
    list.append(("Mining Drill","Omni",{'nose':math.pi,'invertible':True,'range':20,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("Sarcophagus 2","Poker",{'invertible':True,'radius':0.3,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,2)}))
    list.append(("SHW-Genius Loci","FBS",{'nose':math.pi*0.5,'invertible':True,'spinspeed':12,'radius':0.5,'topspeed':99,'throttle':130,'turn':40,'turnspeed':2,'weapons':(1,)}))
	
    # 23 - Blood Thorns "Never underestimate the power of a sawblade on a Magmotor"
    list.append(("LR-4","Omni",{'radius':0.1,'topspeed':99,'range':50,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
    list.append(("Battle Scar v6","OmniVSpinner",{'radius':0.2,'topspeed':99,'range':30,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,2)}))	
    list.append(("Grim Ripper 6","Omni",{'radius':0.2,'topspeed':99,'range':30,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,2,3,4)}))
    list.append(("AW-Scratchy","Omni",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':99,'range':30,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("BW-Rip It Off Good","Omni",{'radius':0.1,'topspeed':99,'range':10,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("SHW-Flesh Feast","Omni",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':99,'range':30,'throttle':130,'turn':40,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8)}))
    
    # 24 - Alkali Metals "Brought to you by H@zm47"
    list.append(("Sodium","Spinner",{'invertible':False,'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(4,5,6,7)}))
    list.append(("Lithium","DirectionalSpinner",{'invertible':True,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,)}))
    list.append(("Potassium","Spinner",{'invertible':False,'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':30,'turnspeed':1,'weapons':(9,10,11,12,13,14,15,16)}))
    list.append(("Rubidium","Omni",{'invertible':False,'range':99,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(21,22)}))
    list.append(("Caesium","Spinner",{'range':99,'direction':-1,'radius':0.4,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2,'weapons':(1,)}))
    list.append(("Francium","Omni",{'invertible':False,'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(42,43)}))
	
    # 25 - Black Hole "Winning is relative"
    list.append(("Quark","Spinner",{'invertible': True, 'radius':0.5, 'topspeed':99, 'throttle':130,'weapons':(1,2,3)}))
    list.append(("Photon","Spinner",{ 'turn':30,'radius':1,'range':99,'weapons':(1,2,)}))
    list.append(("E=mc2","Omni",{'invertible': True, 'radius':0.5,'topspeed':60,'throttle':130, 'range':70,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Standard Theory","Spinner",{'range':99,'nose' : -math.pi,'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turnspeed':3.5,'range':99,'weapons':(1,2)}))
    list.append(("Black Matter","Rammer",{'invertible':True,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(61,2,3,4,5,6,7,8,9,10,11)}))
    list.append(("Boson","Spinner",{'throttle':130,'topspeed':99,'turn':50,'turnspeed':2,'range':99,'radius':0.5, 'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,)}))	
    
    # 26 - The Deadpool "Brought to you by Pwnator"
    list.append(("Warhead 2","Rammer",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Dreamcatcher 2","PillarPlus",{'invertible':True,'range':10,'radius':1,'topspeed':10,'throttle':130,'turn':60,'turnspeed':5,'weapons':(1,2,3)}))
    list.append(("Grey Matter X","Omni",{'invertible':True,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.2,'weapons':(1,2,3,4)}))
    list.append(("Infection 2","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':5,'weapons':(1,2,3,4)}))
    list.append(("Paper Cut 3","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4)}))
    list.append(("Monochrome 2","Flipper",{'invertible':False,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9)}))
    
    # 27 - Team Destroyer "Destroying the opposition"
    list.append(("Micro Destroyer","VertSpinner",{'invertible':False,'radius':0.2,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Mini Destroyer","VertSpinner",{'invertible':False,'radius':0.3,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Destroyer HP","VertSpinner",{'invertible':False,'radius':1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Micro Destroyer 2","VertSpinner",{'invertible':False,'radius':0.2,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Mini Destroyer 2","VertSpinner",{'invertible':False,'radius':0.3,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Destroyer WDB 2","VertSpinner",{'invertible':False,'radius':1.5,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2)}))
    
    # 28 - Team Destroyer 2 "Still destroying the opposition"
    list.append(("Micro Destroyer 4","VertSpinner",{'invertible':False,'radius':0.2, 'range':40,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Thumper 4","Spinner",{'invertible':False,'radius':0.2, 'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Rocket Launcher 3","Flipper",{'invertible':False,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':3.5,'weapons':(1,)}))
    list.append(("Circle of Terror 3","Omni",{'invertible':True,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(1,)}))
    list.append(("Grinder  2","Omni",{'invertible':True,'radius':0.1, 'range':40,'topspeed':100,'throttle':130,'turn':80,'turnspeed':3,'weapons':(1,2)}))
    list.append(("Destroyer FHP","Omni",{'invertible':False,'radius':0,'range':99,'topspeed':100,'throttle':130,'turn':40,'turnspeed':2,'weapons':(1,2)}))
	
    # 29 - ENT_toxic_X "Caution : extremely toxic"
    list.append(("Gutsy Move","Poker",{'nose':math.pi*0.5,'radius':0.1,'throttle':130,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(3,4,5)}))
    list.append(("+Plus+","Poker",{'nose':math.pi*2,'radius':0.1,'throttle':130,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(3,4,5,6)}))
    list.append(("Reanimation","VertSpinner",{'invertible':False,'nose':math.pi,'range':99,'radius':0.3,'throttle':130,'topspeed':99,'topspeed':99,'turn':60,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("The Vortex","OmniRam",{'invertible':True,'nose':math.pi*0.5,'radius':0.1,'throttle':130,'topspeed':99,'turn':60,'turnspeed':2,'weapons':(7,8,9)}))
    list.append(("Evil","Omni",{'nose':math.pi,'radius':math.pi*2,'range':20,'radius':0.1,'throttle':130,'topspeed':99,'weapons':(12,13,14,15,16,17,18,19,20)}))
    list.append(("Slide Show","Poker",{'nose':math.pi,'radius':0.1,'throttle':130,'topspeed':99,'turn':80,'turnspeed':4,'weapons':(1,2,3,4)}))
	
    # 30 - Happy King Cat  "The king gets bored, give him some fun"
    list.append(("Cat","Spinner",{'range':80 , 'radius':1, 'topspeed':99, 'turn':60, 'throttle':130,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Black Panther","VertSpinner",{'radius':1,'topspeed':100,'throttle':130,'turn':100,'turnspeed':3.5,'range':99,'weapons':(19,),'sweapons':(19,)}))
    list.append(("Tiger","Omni",{'invertible':True, 'range':30 , 'nose':math.pi/2, 'topspeed':99, 'throttle':130,'weapons':(1,2,3,4,5,6)}))
    list.append(("Jaguar","Flipper",{'nose':math.pi, 'radius':0.5,'topspeed':99,'throttle':130,'turnspeed':3.5,'range':99,'weapons':(1,2)}))
    list.append(("Felix","LaserGuidedV2",{'nose':math.pi,'range':80, 'radius':0.5, 'servospeed':60, 'topspeed':99, 'mayFire':False, 'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Schrodinger's Cat" ,"Spinner",{'nose':math.pi,'range':99, 'radius' :1, 'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))
	
    # 31 - Legless Beasts "Brought to you by Somebody"
    list.append(("Ribbon Snake","OmniRam",{'invertible':True,'turn':50,'turnspeed':3,'radius':0.5,'topspeed':100,'throttle':130,'weapons':(1,2,17,18)}))    
    list.append(("Python","FBSInvertDir",{'nose':math.pi*0.8,'invertible':True,'turn':30,'turnspeed':2.5,'radius':0.5,'topspeed':100,'throttle':130,'weapons':(1,8)}))
    list.append(("Black Mamba 10","Omni",{'nose':math.pi,'invertible':True,'turn':50,'turnspeed':3,'radius':1,'topspeed':100,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("Pit Viper 8","Drum",{'nose':math.pi,'invertible':True,'turn':60,'turnspeed':4,'radius':1,'topspeed':100,'throttle':130,'range':99, 'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("Shovelnose 3","Popup",{'invertible':False,'turn':40,'turnspeed':3,'radius':0.5,'topspeed':100,'throttle':130, 'range':99, 'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("Water Moccasin 8","OmniRam",{'nose':math.pi,'invertible':True,'turn':40,'turnspeed':3,'radius':0.5,'topspeed':100,'throttle':130,'weapons':(1,)}))
    
    # 32 - Monster Inside "Do NOT touch"
    list.append(("Cutie","Poker",{'nose':math.pi, 'radius':0.5, 'topspeed':99,'throttle':130,'turn': 30, 'range':99,'weapons':(1,2,)}))
    list.append(("Pretty  Me","Omni",{'range':20,'nose':math.pi,'invertible':True,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Big Love","Flipper",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)}))
    list.append(("BongL","Rammer",{'invertible': True,'radius':0.8,'topspeed':99,'throttle':130}))
    list.append(("BongM","Rammer",{'invertible': True,'radius':0.8,'topspeed':99,'throttle':130}))
    list.append(("BongH","Rammer",{'invertible': True,'radius':0.8,'topspeed':99,'throttle':130}))
    	
    # 33 - Orcish Power "Nothing but rust and dust"
    list.append(("Goblin Strike","Poker",{'invertible':True, 'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':5,'weapons':(1,2,3,4)}))
    list.append(("Half-Orc","Spinner",{'nose':math.pi,'invertible':True,'topspeed':99,'throttle':130,'turn':80,'turnspeed':4,'range':99,'weapons':(1,2,3)}))
    list.append(("Hill Giant","Spinner",{'range':99,'invertible':True,'radius':0.5,'turn':30, 'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("Icy Goblin","Pusher",{'invertible':True,'turn':30,'radius':0.5,'range':99,'weapons':(1,2,3,)}))
    list.append(("The Machine","Omni",{ 'range':99,'nose' : math.pi/2, 'radius':0.5, 'topspeed':99, 'throttle':130,'weapons':(1,2,3,4)}))
    list.append(("Ogre","Spinner" ,{'range':99, 'nose' : math.pi/2,  'invertible': True,'radius' :2, 'Turn':30, 'topspeed':99, 'throttle':130,'weapons':(1,2,3,4)}))
    
    # 34 - Overpowered Fly "Got hundred eyes to see your tears" 
    list.append(("Mosquito","WhipperPlus",{'invertible':True,'whip':"around",'nose':math.pi*0.5,'radius':0.2,'topspeed':99,'throttle':130,'turnspeed':3.5,'weapons':(1,2,3,4,)}))
    list.append(("Fly Swarm","WhipperPlus",{'invertible':True,'whip':"around",'nose':math.pi*0.5,'radius':1,'throttle':20,'turn':30,'turnspeed':1,'weapons':(4,5,6,7,8,9,10,11)}))
    list.append(("Blood Wasp","Spinner",{'nose':math.pi,'range':99,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("New Game","Rammer",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,)}))
    list.append(("Spider Inside","Pusher",{'invertible':True,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,)}))
    list.append(("Play Evil","Poker",{'nose':-math.pi,'invertible': True,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,)}))

    # 35 - Team Psyco "We are Dementia"
    list.append(("The Ugly","Spinner",{'nose':math.pi*2,'radius':0.5,'range':50,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.25,'weapons':(10,11,)}))
    list.append(("Death On A Stick","FBS_1",{ 'PreSpinEntrance':30, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':2.5, 'weapons':(10,11,12,13)}))
    list.append(("Lousy Launcher  V2","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':15,'turnspeed':3,'weapons':(18,19)}))
    list.append(("VeXxEd?!","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1,'weapons':(13,14,15,16,17,18,19,20,21,22,23,24,25)}))
    list.append(("The Devil's Lime 2","Flipper",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.0,'weapons':(18,19,20,21,22,23)}))
    list.append(("Purple Pest","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(42,43,44,45)}))
   
    # 36 - Team Ragnell Revamped "We fight for our friends, with even more strength than before!"
    list.append(("V.M. Worker","FBS_1",{'invertible':True,'PreSpinEntrance':0,'SpinDirection(1/-1)':-1,'ReMobilizeRoutineTime(10-60)':20,'range':99,'radius':0.1,'topspeed':12,'throttle':20,'turn':30,'turnspeed':1,'weapons':(9,11)}))
    list.append(("P. Clavata 3","Popup",{'NoChassisTime':3,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(7,8,9,10,11,12)}))
    list.append(("Civil Offense III","Omni",{'invertible':True,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.2,'weapons':(25,26)}))
    list.append(("AW-Hornet Larva","FBS_1",{'invertible':True,'PreSpinEntrance':0,'SpinDirection(1/-1)':-1,'ReMobilizeRoutineTime(10-60)':20,'range':99,'radius':0.1,'topspeed':12,'throttle':20,'turn':30,'turnspeed':1,'weapons':(9,11)}))
    list.append(("BW-XBlade^3","Omni",{'invertible':True,'nose':math.pi*2,'range':30,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(6,9,10,11,12)}))
    list.append(("Crosswind X4","FBS_1",{'invertible':True,'PreSpinEntrance':0,'SpinDirection(1/-1)':-1,'ReMobilizeRoutineTime(10-60)':20,'range':99,'radius':0.1,'topspeed':120,'throttle':120,'turn':30,'turnspeed':1.5,'weapons':(9,11)}))
    
    # 37 - Team Suicide "The power of negative thought"
    list.append(("Call of the Tomb","Spinner",{'radius':0.5, 'topspeed':99,'throttle':130,'turn': 30, 'range':99,'weapons':(1,2,)}))
    list.append(("Overdose","Omni",{'nose':math.pi/2,'range':3,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':5,'weapons':(1,2,3)}))
    list.append(("Poison of Maatet","LaserGuidedV2",{'nose':math.pi,'range':80, 'radius':0.5, 'servospeed':60, 'topspeed':99, 'mayFire':False, 'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Medecine","Spinner",{'nose':math.pi,'range':60,'radius':0.5, 'topspeed':3.8,'throttle':130,'weapons':(1,2,3)}))
    list.append(("Bad Mood", "Spinner",{'range':80,  'invertible': True,  'topspeed':99, 'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Hara-Kiri","Spinner" ,{'nose':math.pi,'range':99,  'radius' :1,  'topspeed':99, 'throttle':130,'weapons':(1,2,3,4,5,6,7,8)}))    	

    # 38 - TwisteD MetaL "Brought to you by S32"
    list.append(("Karma","FBS_2",{'range':99,'topspeed':15.0,'throttle':120,'weapons':(1,15,16,17,18,19,20,21)}))
    list.append(("Prophecy","EcoOmni",{'range':70,'topspeed':15.0,'throttle':120,'weapons':(15,16,17,18,19,20,21)}))
    list.append(("Bad Chi","Omni",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':20.0,'throttle':115,'weapons':(1,13,14,15,16,17,18,19,20)}))
    list.append(("AW - Reincarnation","Rammer",{'range':70,'radius':0.1,'topspeed':15.0,'throttle':130,'weapons':(15,16,17,18,19,20,21)}))
    list.append(("BW - Fate","FBS_2",{'range':99,'topspeed':15.0,'throttle':130,'weapons':(15,16,17,18,19,20,21)}))
    list.append(("SHW - Destiny","FBS_2",{'range':99,'topspeed':15.0,'throttle':130,'weapons':(15,16,17,18,19,20,21)}))    
	
    # 39 - Twisters "Death at 318 MPH"
    list.append(("BW-Spiraling Compass","FBS_1",{ 'PreSpinEntrance':5, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(11,12,13,14,15,16)}))
    list.append(("Bane II","FBS_1",{ 'PreSpinEntrance':5, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(11,12,13,14,15,16)}))
    list.append(("Circle of Thorns III","FBS_1",{'nose':-math.pi,'PreSpinEntrance':4, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26)}))
    list.append(("Devilish Charm","FBS_1",{ 'PreSpinEntrance':4, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(11,12,13,14,15,16,17,18,19,20,21,22)}))
    list.append(("SHW-Hellish Charm","FBS_1",{ 'PreSpinEntrance':10, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(10,11,12,13,14,15,16,18,19,20,21,22,23,24,25,26)}))
    list.append(("Weapon Array","FBS_1",{'nose':math.pi*0.5, 'PreSpinEntrance':7, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':25, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(10,11,12,13,14,15,16,18,19,20,21,22,23,24,25,26,27,29,30,31,32,33,34,35,36,37,38,39)}))
    
    # 40 - Wriddlers Wreturn "The pen is mightier than the saw"
    list.append(("AW-Nit-Picker II","Pusher",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.8}))
    list.append(("Woozo","DirectionalSpinner",{'invertible':True,'nose':math.pi*2,'radius':1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(17,18,19,20,21,22,23,24,25,26,27,28)}))
    list.append(("ZazZawang","Omni",{'invertible':True,'nose':math.pi*2,'radius':1,'range':500,'topspeed':80,'throttle':130,'turn':60,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)}))
    list.append(("Little Door Rat","Omni",{'nose':math.pi*2,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10)}))
    list.append(("Bane III","FBS_1",{'nose':math.pi*0.5,'PreSpinEntrance':5, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(11,12,13,14,15,16,17,18,19,20)}))
    list.append(("The Devil's Cherry","Omni",{'nose':math.pi,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.0,'weapons':(33,45,46,47,48,49,50,51)}))
	
    # 41 - Walking Dead Robotics "You'll join us in the grave..."
    list.append(("Skeleton Warrior","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4,'weapons':(1,)}))
    list.append(("Wraith","Omni",{'invertible':True,'range':10,'nose':math.pi,'radius':0.2,'topspeed':100,'throttle':130,'turn':40,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Lich Lord","Omni",{'invertible':False,'range':50,'nose':math.pi,'radius':0.5,'topspeed':100,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("AW-Requiem","Omni",{'invertible':True,'range':5,'radius':0.2,'topspeed':100,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("BW-Bone Curse","Flipper",{'invertible':False,'nose':math.pi,'radius':0.2,'topspeed':100,'throttle':130,'turn':40,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("SHW-Resident Evil","Spinner",{'radius':3,'range':99,'topspeed':90,'throttle':130,'turn':60,'turnspeed':4,'weapons':(1,)}))
	
    # 42 - Team Violence "RAWR !"
    list.append(("Bloody Mess","Spinner",{'radius':0.7,'range':99,'throttle':130,'topspeed':99,'turn':80,'turnspeed':6,'weapons':(8,9)}))
    list.append(("Deathwish","Omni",{'invertible':True,'range':50,'radius':0.4,'throttle':130,'topspeed':99,'turn':40,'turnspeed':3,'weapons':(8,9)}))
    list.append(("Mindless Aggression 4", "Omni",{'nose':math.pi,'invertible':True,'range':5,'radius':0.5,'throttle':130,'topspeed':99,'turn':40,'turnspeed':3,'weapons':(20,22)}))
    list.append(("The Bot You Like To Hate","FBS",{'invertible':True,'radius':2,'spinspeed':8,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(6,)}))
    list.append(("Born Killer","Flipper",{'radius':0.3,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(18,19,20,21,22)}))
    list.append(("Dies Irae","Omni",{'range':40,'invertible':True,'radius':0.3,'topspeed':100,'throttle':130,'turn':20,'turnspeed':1,'weapons':(18,19,20,21,22)}))
   
    #43 - Team Faggot "Absolutely no building skill"
    list.append(("Tournament's Shame","Omni",{'invertible':True,'ghey':True,'radius':0.3,'throttle':130,'topspeed':99,'turn':30,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Cheap Win 1500", "FBS",{'invertible':True,'ghey':True,'radius':0.5,'spinspeed':8,'throttle':130,'topspeed':99,'turn':60,'turnspeed':5,'weapons':(10,11)}))
    list.append(("The Infamous One", "FBS",{'invertible':True,'ghey':True,'radius':0.5,'spinspeed':12,'throttle':130,'topspeed':99,'turn':80,'turnspeed':5,'weapons':(6,)}))
    list.append(("AW-Disco Fevah","PillarPlus",{'failbot':True,'ghey':True,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':80,'turnspeed':5,'weapons':(6,7,8,9)}))
    list.append(("BW-Fag Roller","Rammer",{'failbot':True,'ghey':True,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':70,'turnspeed':5,'weapons':(2,4)}))
    list.append(("SHW-Rainbow Freak","FBS",{'invertible':True,'ghey':True,'radius':1.5,'spinspeed':3,'throttle':130,'topspeed':99,'turn':100,'turnspeed':6,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))

    #44 - Bronze Age "And then the third race of man was created, and it was terrible and strong. They loved deeds of violence, and great was their strength."
    list.append(("Spirit of Champions","Omni",{'range':30,'invertible':False,'radius':0.2,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3.5,'weapons':(16,)}))
    list.append(("Warhammer","Omni",{'nose':math.pi*0.5,'invertible':False,'radius':0.4,'throttle':130,'topspeed':99,'turn':40,'turnspeed':3,'weapons':(16,)}))
    list.append(("Centurion II","Poker",{'nose':math.pi,'invertible':True,'radius':0.2,'throttle':130,'topspeed':99,'turn':40,'turnspeed':2,'weapons':(1,2,3,4)}))
    list.append(("Blade Barrier","Omni",{'nose':math.pi,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3.5,'weapons':(1,)}))
    list.append(("Legionaire","Poker",{'invertible':True,'radius':0.2,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(11,12,13,14,15)}))
    list.append(("Blood Knight","Poker",{'nose':math.pi,'invertible':True,'radius':0.5,'throttle':130,'topspeed':99,'turn':30,'turnspeed':1.5,'weapons':(1,2,3,4,5,6,7,8,9,10)}))
    
    #45 - Evil Corp. "Come to the dark side... we have cookies"
    list.append(("Torture Device","Popup",{'nose':math.pi,'radius':0.5,'throttle':130,'NoChassisTime':2,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Fallen Hero","FBSInvertDir",{'invertible':True,'nose':math.pi,'radius':2.5,'throttle':130,'spinspeed':12,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,2,3)}))
    list.append(("Inhuman Treatment","Omni",{'invertible':False,'nose':math.pi,'radius':0.5,'throttle':130,'topspeed':99,'turn':40,'turnspeed':2.5,'weapons':(1,2,3)}))
    list.append(("Schadenfreude","Popup",{'radius':0.5,'throttle':130,'NoChassisTime':4,'topspeed':99,'torque':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Harbinger of Doom","Popup",{'radius':0.5,'throttle':130,'NoChassisTime':3,'topspeed':99,'torque':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Genocide","FBS",{'invertible':True,'nose':math.pi*0.5,'radius':1.5,'throttle':130,'spinspeed':12,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,2,3)}))

    #46 - Satanic Cult "All hells come loose !"
    list.append(("Abyssal Spawn","Poker",{'radius':0.5,'throttle':130,'invertible':True,'topspeed':99,'torque':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Devil's Advocate","Poker",{'nose':math.pi,'radius':0.5,'throttle':130,'invertible':True,'topspeed':99,'torque':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Storm Demon","FBS",{'nose':math.pi*1.5,'invertible':True,'radius':1.5,'throttle':130,'spinspeed':8,'topspeed':99,'turn':70,'turnspeed':4,'weapons':(1,)}))
    list.append(("Dark Messiah","Omni",{'nose':math.pi,'invertible':False,'range':50,'radius':1.5,'throttle':130,'topspeed':99,'turn':70,'turnspeed':4,'weapons':(1,)}))
    list.append(("Infernal Contraption 7.1","Omni",{'nose':math.pi,'invertible':False,'range':50,'radius':0.5,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Blade Fiend ","Poker",{'nose':math.pi,'radius':0.5,'invertible':True,'throttle':130,'invertible':True,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    
	#47 - Bioengineering Labs "Pushing DNA really, really far"
    list.append(("Cloning Mishap","FBS",{'radius':0.1,'direction':-1,'nose':math.pi*0.5,'throttle':130,'invertible':True,'spinspeed':10,'topspeed':99,'throttle':130,'turn':40,'turnspeed':2,'weapons':(1,)}))
    list.append(("Carcinogen","WhipperPlus",{'nose':math.pi,'radius':0.3,'throttle':130,'invertible':True,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Mutated  Aberration","Poker",{'nose':math.pi,'radius':0.4,'throttle':130,'invertible':False,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3.5,'weapons':(1,)}))
    list.append(("Mad Doctor's Assistant","Omni",{'radius':0.2,'invertible':True,'throttle':100,'topspeed':20,'turn':60,'range':40,'turnspeed':4,'weapons':(1,)}))
    list.append(("Genetic Plaything","FBSPlus",{'invertible':False,'radius':0.5,'range':50,'throttle':130,'spinspeed':10,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Crazy Experiment","Omni",{'nose':math.pi,'radius':0,'throttle':100,'topspeed':99,'turn':30,'turnspeed':1,'weapons':(1,)}))
	
    #48 - Razor Team "Obvious weapon choice is obvious"
    list.append(("Portable Sawmill","Omni",{'nose':math.pi,'radius':0.1,'throttle':130,'invertible':True,'range':40,'topspeed':99,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
    list.append(("Noisy Assassin","Omni",{'nose':math.pi,'radius':0.2,'throttle':130,'invertible':False,'range':40,'topspeed':99,'throttle':130,'turn':40,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Robotic Surgeon","Omni",{'radius':0.4,'throttle':130,'invertible':False,'range':40,'topspeed':99,'throttle':130,'turn':40,'turnspeed':2,'weapons':(1,)}))
    list.append(("Keen Edge","Pinner",{'nose':math.pi,'radius':0.1,'turn':60,'turnspeed':5,'weapons':(1,)}))
    list.append(("Hook Horror","Omni",{'radius':0.4,'throttle':130,'invertible':False,'range':70,'topspeed':99,'throttle':130,'turn':60,'turnspeed':4,'weapons':(1,)}))
    list.append(("Barbed Scourge","Popup",{'radius':0.4,'throttle':130,'invertible':False,'NoChassisTime':3,'topspeed':99,'throttle':130,'turn':60,'turnspeed':4,'weapons':(1,)}))	
    	
    #49 - The Assassinators "All you have to do... is aim and shoot" (Ounce)
    list.append(("Stiletto 4.0","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':100,'turnspeed':2.5,'weapons':(9,)}))
    list.append(("Rapier","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1.5,'weapons':(26,)}))
    list.append(("Broadsword","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.2,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Telescopic Sight","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("Hellish Uproar","Spinner",{'invertible':True,'nose':math.pi,'radius':2,'range':60,'topspeed':100,'throttle':100,'turn':30,'turnspeed':2,'weapons':(55,)}))
    list.append(("AW-Mercury Poisoning","Spinner",{'nose':math.pi,'range':15,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(2,)}))
	
    #50 - Astral Travel "Into space and beyond" (123STW)
    list.append(("Star Dust","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':100,'turnspeed':4,'weapons':(0,)}))
    list.append(("Core-Collapse Supernova","FBSInvertDir",{'spinspeed':50,'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("Rotation-Powered Pulsar","FBSInvertDir",{'spinspeed':16,'invertible':True,'nose':math.pi*0.25,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':20,'weapons':(0,)}))
    list.append(("AW - Neutrino","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':100,'turnspeed':4,'weapons':(14, )}))
    list.append(("Morning Star XI","FBSInvertDir",{'spinspeed':13,'invertible':True,'nose':math.pi*0.2,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':13,'weapons':(0,)}))
    list.append(("SHW - Quasar","FBS",{'spinspeed':20,'invertible':True,'nose':math.pi*0.25,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
	
    #51 - Blue and Green "Now you know who made this team!" (Trumpetguy)
    list.append(("Singe 9","Poker",{'topspeed':4.0,'invertible':True,'throttle':100,'turn':60,'turnspeed':2.5,'radius':1.0,'weapons':(1,)}))
    list.append(("Claws of the Yeti","Omni",{'topspeed':4.0,'nose':math.pi,'invertible':True,'throttle':100,'turn':60,'turnspeed':2.5,'radius':1.0,'weapons':(1,)}))
    list.append(("Devil May Spin 3","Omni",{'topspeed':4.0,'invertible':True,'throttle':90,'turn':60,'turnspeed':2.5,'radius':1.0,'weapons':(1,)}))
    list.append(("AW-Gatling","Omni",{'topspeed':4.0,'invertible':True,'throttle':100,'turn':60,'turnspeed':2.5,'radius':1.0,'weapons':(1,)}))
    list.append(("BW-Green, Blue Ninja","Omni",{'topspeed':4.0,'invertible':False,'throttle':100,'turn':60,'turnspeed':2.5,'radius':1.0,'weapons':(1,)}))
    list.append(("Blue and Green","Omni",{'topspeed':4.0,'invertible':True,'throttle':100,'turn':60,'turnspeed':2.5,'radius':1.0,'weapons':(1,)}))
	
    #52 - Celestial Objects "The position of the planets tells me that your bots will soon be demolished" (Ounce)
    list.append(("Eris","FBS_1",{ 'PreSpinEntrance':0, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':20, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(11,12,13,14,15,16)}))
    list.append(("Europa","Omni",{'nose':math.pi,'invertible':True,'radius':0.2,'range':30,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(12,13,14,15,16,17)}))
    list.append(("Hydrosphere","Omni",{'invertible':True,'nose':math.pi,'radius':2,'range':60,'topspeed':100,'throttle':100,'turn':30,'turnspeed':2,'weapons':(55,)}))
    list.append(("AW-Ceres","Omni",{'nose':math.pi*2,'radius':0.1,'range':15,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(17,)}))
    list.append(("BW-Oberon","FBS_1",{'invertible':True,'PreSpinEntrance':0,'SpinDirection(1/-1)':-1,'ReMobilizeRoutineTime(10-60)':20,'range':99,'radius':0.1,'topspeed':12,'throttle':20,'turn':30,'turnspeed':1,'weapons':(9,11)}))
    list.append(("SHW-Neptune","FBS_1",{'invertible':True,'PreSpinEntrance':7,'SpinDirection(1/-1)':-1,'ReMobilizeRoutineTime(10-60)':20,'range':99,'radius':0.1,'topspeed':120,'throttle':120,'turn':30,'turnspeed':1.5,'weapons':(9,11)}))

    #53 - Dark Factory of Mass Production (Scrap)
    list.append(("Ballista","Omni",{'nose':math.pi*2,'range':50,'invertible':True,'radius':0.3,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(8,9,10)}))
    list.append(("Disturbance Strategy","Omni",{'nose':math.pi*2,'range':50,'invertible':True,'radius':0.3,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(16,17,18)}))
    list.append(("Abyssal Designator","Omni",{'nose':math.pi*2,'range':50,'invertible':True,'radius':0.3,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(24,25,26)}))
    list.append(("AW-The Prodigy","Omni",{'nose':math.pi*2,'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,13)}))
    list.append(("BW-Byter","Omni",{'nose':math.pi*2,'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,13)}))
    list.append(("Evil Intent","PillarPlus",{'invertible':True,'radius':1,'range':0.01,'range2':99, 'radius':0.1, 'topspeed':100, 'throttle':130, 'turn':60, 'turnspeed':5,'weapons':(14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29)}))
	
    #54 - The Diseased "Swine Flu has nothing on us !" (Scrap)
    list.append(("Epidemic","Poker",{'nose':math.pi*2,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':80,'turnspeed':3,'weapons':(5,)}))
    list.append(("Pandemic","Poker",{'nose':math.pi*2,'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':80,'turnspeed':3,'weapons':(6,)}))
    list.append(("Biological Warfare","Poker",{'nose':math.pi*2,'invertible':False,'radius':0.1,'throttle':130,'topspeed':99,'turn':80,'turnspeed':3,'weapons':(6,)}))
    list.append(("Area Control","Omni",{'nose':math.pi*2,'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,13)}))
    list.append(("Infectious Disease","Omni",{'nose':math.pi*2,'range':20,'invertible':True,'radius':0.3,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(13,14)}))
    list.append(("QUARANTINE","Omni",{'nose':math.pi*2,'range':20,'invertible':True,'radius':0.3,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(13,14)}))
	
    #55 - The DOH "The Dangers of the Hospital are... deadly" (Doomkiller)
    list.append(("Just a Cut...","Spinner",{'invertible':True,'range':100,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':5,'weapons':(27,28,29,30,35,36,37,38,39,40,41,42,43,44,45,46,47,48,53,54)}))
    list.append(("Infectious Virus","DirectionalSpinner",{'invertible':True,'range':100,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(27,28,29,30,35,36,37,38,39,40,41,42,43,44,45,46,47,48,53,54)}))
    list.append(("Emergency Surgery","DirectionalSpinner",{'invertible':True,'range':100,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(27,28,29,30,35,36,37,38,39,40,41,42,43,44,45,46,47,48,53,54)}))
    list.append(("Infectious Tools","DirectionalSpinner",{'invertible':True,'range':100,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(27,28,29,30,35,36,37,38,39,40,41,42,43,44,45,46,47,48,53,54)}))
    list.append(("Speedy Recovery","Pusher",{'invertible':True,'range':100,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(27,28)}))
    list.append(("Forever Doomed","Popup",{'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(27,28,29)}))
	
    #56 - Fairy Tales "Brought to you by Virus Bomb" (Obvious)
    list.append(("Prince Harming","Omni",{'nose':math.pi,'invertible':True,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17,18,19,20,21)}))
    list.append(("Wyvern","VertSpinner",{'invertible':False,'nose':math.pi,'radius':0.3,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,20)}))
    list.append(("Knight In Rusty Armor","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'range':99,'topspeed':150,'throttle':130,'turn':60,'turnspeed':3,'weapons':(4,6,13,14,15,16,17,18,19,20,21,22,23,24,25,26,37,38,39,40,47,50)}))
    list.append(("Dragon","VertSpinner",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(13,14,15,16)}))
    list.append(("BW-Princess","Spinner",{'nose':math.pi,'range':99,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17,18,21)}))
    list.append(("Evil Princess","FBSPlus",{'nose':math.pi*1.8,'range':99,'radius':0.4,'topspeed':80,'throttle':130,'turn':60,'turnspeed':5,'weapons':(2,3,4,5,6,7,8,9,10,11,12,13,14)}))
	
    #57 - Team Hell "Don't expect to leave alive" (G.K.)
    list.append(("Styx","FBS",{ 'invertible':True,'spinspeed':8, 'direction':1,'range':99, 'radius':1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(12,13,14,15)}))
    list.append(("Ecam's Avenger","Rammer",{'invertible':True,'radius':1,'topspeed':100,'throttle':100,'turn':60,'turnspeed':1,'weapons':(8,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33)}))
    list.append(("Charon","FBS",{'invertible':True,'direction':-1,'radius':1,'range':0.01,'range2':99, 'radius':0.1, 'topspeed':100, 'throttle':130, 'turn':60, 'turnspeed':5,'weapons':(7,8,9,10,11,1217,18,19,20)}))
    list.append(("AW - Hell Hub","FBS",{ 'spinspeed':8, 'direction':1, 'range':99, 'radius':0.1, 'topspeed':120, 'throttle':120, 'turn':30, 'turnspeed':1.5, 'weapons':(10,11,14,15)}))
    list.append(("Vortex of Doom","Poker",{'invertible':True,'radius':1.1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':1,'weapons':(30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45)}))
    list.append(("SHW - Reaper Two the Max","Spinner",{'topspeed':100,'radius':1.2,'throttle':130,'range':99,'turn':100,'turnspeed':1.5,'weapons':(28,29,30,31,32,33,34,35,36,37,39,51,52,53,54,55,56,57,58,59,60,61,73,74,75,76,77,78,79,80,81,82,83,89,90,91)}))
    
    #58 - 1337 Horror Franchise (Russian Roulette)
    list.append(("8UR13D 4L1V3","Spinner",{'invertible':False,'nose':math.pi,'radius':0.5,'range':50,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,2)}))
    list.append(("7H3 3X0RC157","Pinner",{'nose':math.pi*1.5,'weapons':(1,)}))
    list.append(("7337H","Omni",{'invertible':False,'radius':0.5,'nose':math.pi,'range':50,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,2)}))
    list.append(("AW-CU83 Z3R0","FBS",{'nose':math.pi*0.7,'invertible':True,'radius':0.1,'throttle':130,'spinspeed':8,'topspeed':99,'turn':70,'turnspeed':4,'weapons':(1,)}))
    list.append(("BW-54W","FBS",{'nose':math.pi,'invertible':True,'radius':0.1,'throttle':130,'spinspeed':3,'topspeed':99,'turn':70,'turnspeed':4,'weapons':(1,)}))
    list.append(("SHW-J0Y R1D3","Pinner",{'nose':math.pi,'weapons':(1,)}))

    #59 - The Inglorious Basterds (Pwn)
    list.append(("The Apache","Omni",{'radius':0.1,'range':30,'topspeed':100,'throttle':130,'turn':80,'turnspeed':5,'weapons':(17,18,19)}))
    list.append(("The Bear Jew","Omni",{'invertible':True,'radius':0.1,'topspeed':130,'throttle':130,'turn':90,'turnspeed':2.5,'weapons':(20,21)}))
    list.append(("The Jew Hunter","Omni",{'range':99,'radius':1,'topspeed':130,'throttle':150,'turn':90,'turnspeed':3.5,'weapons':(27,28)}))
    list.append(("AW - The Little Man","Rammer",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("BW - Nation's Pride","Rammer",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':40,'turnspeed':4}))
    list.append(("The Inglourious Basterd","BountyHunter",{'range':500,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48)}))
	
    #60 - Launch Vehicles "Not your average carnival rides" (Pwn)
    list.append(("Kinetic Energy Penetrator","Omni",{'range':99,'radius':1,'topspeed':130,'throttle':150,'turn':70,'turnspeed':3,'weapons':(22,23,24,25,26)}))
    list.append(("Mass Driver","Omni",{'invertible':True,'range':30,'radius':1,'topspeed':130,'throttle':100,'turn':45,'turnspeed':3,'weapons':(19,20,21)}))
    list.append(("Particle Accelerator","Omni",{'invertible':True,'range':60,'radius':1,'topspeed':130,'throttle':130,'turn':50,'turnspeed':3,'weapons':(33,34,35,36,37,38)}))
    list.append(("Ion Thruster","Omni",{'range':99,'radius':1,'topspeed':130,'throttle':130,'turn':70,'turnspeed':3,'weapons':(10,11,12,13,14)}))
    list.append(("Antimatter","Omni",{'range':99,'radius':1,'topspeed':130,'throttle':90,'turn':50,'turnspeed':3,'weapons':(28,29)}))
    list.append(("SHW - Dark Matter 2","Omni",{'invertible':True,'range':99,'radius':1,'topspeed':130,'throttle':130,'turn':70,'turnspeed':3,'weapons':(29,30,31,32,33,34)}))
	
    #61 - Loaded Dice "Brought to you by JoeBlo" (Obvious)
    list.append(("Snake Eyes","Octane",{'PreSpinEntrance':5,'SpinDirection':1,'ReMobilizeRoutineTime':20,'nose':math.pi/2,'radius':0.3,'range':99,'topspeed':100,'throttle':100,'turn':45,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Double Or Nothing","Octane",{'PreSpinEntrance':5,'SpinDirection':1,'ReMobilizeRoutineTime':20,'nose':math.pi*2,'radius':0.3,'range':99,'topspeed':100,'throttle':100,'turn':45,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Betting Limits","Octane",{'PreSpinEntrance':5,'SpinDirection':-1,'ReMobilizeRoutineTime':20,'nose':math.pi*2,'radius':0.3,'range':99,'topspeed':100,'throttle':100,'turn':45,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Lucky 7s","Octane",{'PreSpinEntrance':1,'SpinDirection':1,'ReMobilizeRoutineTime':20,'nose':math.pi*2,'radius':0.3,'range':99,'topspeed':100,'throttle':100,'turn':45,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("High Roller","Octane2",{'nose':math.pi,'radius':0.2,'topspeed':100,'throttle':100,'turn':40,'turnspeed':2,'weapons':(10,11,12,13)}))
    list.append(("SHW-Double Down","Octane2",{'nose':math.pi,'radius':0.2,'topspeed':100,'throttle':100,'turn':40,'turnspeed':2,'weapons':(10,11,12,13)}))    

    #62 - Magical Land "Where cows eat you" (123STW)
    list.append(("Funny Bunny","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.2,'weapons':(0,)}))
    list.append(("Second Sunrise","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.2,'weapons':(0,)}))    
    list.append(("Arctic Fox","Omni",{'invertible':True,'nose':math.pi*1.5,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
    list.append(("Sky Whale II","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':40,'turnspeed':4,'weapons':(0,)}))
    list.append(("Cash Cow","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
    list.append(("SHW - Holy Cow","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
	
    #63 - Midnight Snacks "Will they be eaten ? Or will you ?" (123STW)
    list.append(("Milk Shake","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':100,'topspeed':99,'turn':100,'turnspeed':3,'weapons':(0,)}))
    list.append(("Soda Pop","Flipper",{'nose':math.pi*1,'invertible':False,'range':99,'radius':0.1,'throttle':130,'topspeed':99,'turn':65,'turnspeed':3.5,'weapons':(0,)}))
    list.append(("Candy Bar","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("French Fries","Omni",{'invertible':True,'nose':math.pi*1.5,'range':99,'radius':1.5,'throttle':90,'topspeed':99,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("Sloppy Joe","Omni",{'invertible':True,'nose':math.pi*0.5,'range':99,'radius':1.5,'topspeed':100,'throttle':130,'turn':99,'turnspeed':99,'weapons':(0,)}))
    list.append(("SHW - Root Beer","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
	
    #64 - Popular Mechanics "Keep it stupid, simple." (Reier)
    list.append(("Short Circuit","Rammer",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':0.15}))
    list.append(("Zapper","Popup",{'radius':0.1,'range':15,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(17,18,19,20,21,22)}))
    list.append(("Ramjet","Pusher",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("AW-Pyro","FlameOmni",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,)}))
    list.append(("Fuse[D]","Omni",{'range':50,'nose':math.pi,'radius':0.2,'topspeed':100,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
    list.append(("Hot Rod","SZSpinner",{'invertible':False,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':300,'turn':80,'turnspeed':5}))
    
    #65 - The Resistance "Resistance is NOT futile!" (Reier)
    list.append(("Combatant","Omni",{'nose':math.pi,'invertible':True,'radius':0.1,'range':15,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(17,18,19,20)}))
    list.append(("[S] Cargo","OmniVSpinner",{'nose':math.pi,'radius':0.1,'range':60,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Code Yellow","Rammer",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("BW - DeWalt","Omni",{'invertible':True,'radius':0.1,'range':15,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(17,18,19,20)}))
    list.append(("Cadet","Omni",{'invertible':True,'radius':0.1,'range':15,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1,'weapons':(17,18,19,20,21,22,23,24)}))
    list.append(("Convoy","FBS_1",{'PreSpinEntrance':6, 'SpinDirection(1/-1)':1, 'ReMobilizeRoutineTime(10-60)':10, 'range':99, 'radius':0.1, 'topspeed':100, 'throttle':130, 'turn':30, 'turnspeed':1.5, 'weapons':(13,14,15,16)}))
	
    #66 - Team Rewind "Back to the future" (Urjak)
    list.append(("Lasceron","OmniRam",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':3.5,'weapons':(1,)}))
    list.append(("VeXxEd?!","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1,'weapons':(13,14,15,16,17,18,19,20,21,22,23,24,25)}))
    list.append(("Vertical Impulse","Flipper",{'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':50,'turnspeed':2.5,'weapons':(1,2)}))
    list.append(("BW-Sub-Atomic","Spinner",{'nose':math.pi*2,'range':30,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(6,9,10,11,12)}))
    list.append(("Woozo","DirectionalSpinner",{'invertible':True,'nose':math.pi*2,'radius':1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(17,18,19,20,21,22,23,24,25,26,27,28)}))
    list.append(("The Devil's Maul","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':80,'turnspeed':2.5,'weapons':(18,19,20,21,22,23,24,25,26,27,28,29)}))
	
    #67 - srezinwP "!denwP" (GK & SM)
    list.append(("ymgyP","Spinner",{'range':40,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(24,25,26,27,28,29,30,31)}))
    list.append(("ecivoN","Rammer",{'invertible':True,'radius':1.5,'range':50,'topspeed':100,'turn':50,'turnspeed':3,'weapons':(10,12,14)}))
    list.append(("75.5 ?iouQ tE","Omni",{'radius':1.5,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(32,33,34,35,36,37,38,39,40,41,48,49)}))
    list.append(("2 pergE","Omni",{'invertible':True,'radius':1.5,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(15,16,17,18,19,20)}))
    list.append(("BW - 2 esallikoboR","Rammer",{'invertible':True,'radius':1,'topspeed':100,'throttle':100,'turn':70,'turnspeed':3,'weapons':(10,11,12)}))
    list.append(("SHW - 2 niarT niarreT llA","FBSPlus",{'invertible':True,'direction':1,'spinspeed':8,'radius':0.2,'range':50,'topspeed':100,'turn':70,'turnspeed':5,'weapons':(26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,61,62,63,64)}))
	
    #68 - Team Uncia "Brought to you by the Ounce"
    list.append(("DiSemboweLment","Popup",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(10,)}))
    list.append(("Iron Tumbleweed V","Omni",{'invertible':True,'nose':math.pi,'radius':0.3,'range':50,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Pulsar vX","Spinner",{'nose':math.pi,'radius':1.5,'topspeed':100,'range':99,'throttle':130,'turn':60,'turnspeed':4,'weapons':(2,)}))
    list.append(("BW-Hornet Scout","FBS_1",{'invertible':True,'PreSpinEntrance':0,'SpinDirection(1/-1)':-1,'ReMobilizeRoutineTime(10-60)':20,'range':99,'radius':0.1,'topspeed':12,'throttle':20,'turn':30,'turnspeed':1,'weapons':(9,11)}))
    list.append(("ReFraction","Omni",{'invertible':True,'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':3,'weapons':(55,)}))
    list.append(("SHW-Forcewind","FBS_1",{'invertible':True,'PreSpinEntrance':0,'SpinDirection(1/-1)':-1,'ReMobilizeRoutineTime(10-60)':20,'range':99,'radius':0.1,'topspeed':120,'throttle':120,'turn':30,'turnspeed':1.5,'weapons':(9,11)}))
	
    #69 - Windstorms from Hell "Brought to you by Badnik96"
    list.append(("Burning Z","Spinner",{'invertible':False,'range':50,'nose':math.pi,'radius':0.2,'topspeed':99,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
    list.append(("Hellcopter Evolution","Spinner",{'invertible':False,'range':50,'radius':0.5,'topspeed':99,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
    list.append(("Hellcopter Alpha","Spinner",{'invertible':False,'range':50,'radius':0.7,'topspeed':99,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
    list.append(("Spitfire 2.5","Popup",{'invertible':False,'radius':0.2,'topspeed':99,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
    list.append(("HellBlade","Omni",{'invertible':False,'range':50,'radius':0.3,'topspeed':99,'throttle':130,'turn':50,'turnspeed':4,'weapons':(1,)}))
    list.append(("SHW-Flaming Tires","Pinner",{'radius':0.5,'turn':20,'turnspeed':1,'weapons':(1,)}))

    #70 - The n00b army "The evil n00bishness is coming..." (STC)
    list.append(("Box Of Evil Noobishness","Omni",{'range':500,'radius':0.1,'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':5,'weapons':(1,2)}))
    list.append(("n00b Scraper","Pusher",{'range':80,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("AW - That Annoying New Guy","Pusher",{'range':60,'radius':0.5,'topspeed':3.8,'throttle':130,'weapons':(1,2)}))
    list.append(("BW-n00b","Omni",{'range':80,'invertible':True,'topspeed':99, 'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("BoEN HW","Omni",{'invertible':True,'range':99,'radius' :0.1,'topspeed':99, 'throttle':130,'weapons':(1,2)}))
    list.append(("SHW-Destructive Noobishness","Omni",{'radius':0.5,'topspeed':99,'range':500,'turn':65,'throttle':130,'weapons':(1,2,)}))
	
    #71 - Organization XIII "We will stop at nothing to achieve Kingdom Hearts" (Badnik)
    list.append(("Demyx, Wielder of Water","FBS_1",{ 'nose':math.pi*0.5, 'PreSpinEntrance':3, 'SpinDirection(1/-1)':-1, 'ReMobilizeRoutineTime(10-60)':15, 'range':99, 'radius':0.1, 'topspeed':100, 'throttle':130, 'turn':60, 'turnspeed':2, 'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Lexaeus, Wielder of Earth","Omni",{'invertible':False,'radius':0.1,'range':99,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(29,41,42)}))
    list.append(("Xemnas, Nothingness Wielder","DirectionalSpinner",{'invertible':True,'range':99,'radius':0.1,'range':99,'topspeed':90,'throttle':100,'turn':60,'turnspeed':2.5,'weapons':(10,)}))
    list.append(("Larxene, Wielder of Thunder","Rammer",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':5,'weapons':(8,9)}))
    list.append(("Axel, Wielder of Fire","Omni",{'invertible':True,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14)}))
    list.append(("SHW-Saix, Berserk Warrior","Omni",{'range':500,'radius':0.1,'topspeed':100,'throttle':130,'turn':20,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10)}))
	
	#72 - Infernal Retaliation "When the Planes burn and all life is torches, then we shall at last... be at peace..."
    list.append(("Scorcher","FlameOmni",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Crazed Arsonist","FlameOmni",{'invertible':True,'radius':0.2,'topspeed':100,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("Man On Fire","FlameOmni",{'invertible':True,'radius':0.4,'topspeed':100,'throttle':130,'turn':70,'turnspeed':5,'weapons':(1,)}))
    list.append(("AW-Mantle of Flame","FBS",{'radius':0.1,'nose':math.pi*0.5,'throttle':130,'invertible':True,'spinspeed':8,'topspeed':99,'throttle':130,'turn':50,'turnspeed':3,'weapons':(1,)}))
    list.append(("BW-Burning Desire","FlameOmni",{'invertible':True,'radius':0.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4,'weapons':(1,)}))
    list.append(("UHW-Ultra High Temperature","FlameOmni",{'invertible':True,'radius':2.0,'topspeed':100,'throttle':130,'turn':70,'turnspeed':5,'weapons':(1,)}))
	
	#73 - The FFFUUUrious Four "Beating you with Amazing Rage"
    list.append(("FFFUUUrious HS","Spinner",{'range':50,'radius':0.1,'invertible':True,'topspeed':100,'throttle':130,'turn':20,'turnspeed':2,'weapons':(1,)}))
    list.append(("FFFUUUrious SnS","FBS",{'spinspeed':12,'direction':-1,'radius':0.1,'invertible':True,'topspeed':100,'throttle':130,'turn':20,'turnspeed':2,'weapons':(1,)}))
    list.append(("FFFUUUrious Pusher","Pinner",{'turn':60,'turnspeed':4}))
    list.append(("FFFUUUrious VS","Omni",{'range':50,'radius':0.1,'invertible':True,'topspeed':100,'throttle':130,'turn':40,'turnspeed':3,'weapons':(1,)}))
	
    #74 - Team 42 "The Answer to Everything" (G.K)
    list.append(("Pan Galactic Gargle Blaster","Pusher",{'invertible':True,'radius':1.5,'range':50,'topspeed':100,'turn':50,'turnspeed':3,'weapons':(11,12)}))
    list.append(("Enigma","Popup",{'nose':math.pi,'NoChassisTime':1,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(7,8)}))
    list.append(("Marvin","Spinner",{'radius':2,'range':99,'topspeed':100,'turn':70,'turnspeed':5,'weapons':(37,38,39,40,41,42,43,44,45,46,47,48,61,62,63,64,65,66,67,68,69,70,71,72,74)}))
    list.append(("AW - Mostly Harmless","Rammer",{'nose':math.pi,'invertible':True,'radius':1.5,'range':50,'topspeed':100,'turn':50,'turnspeed':3,'weapons':(11,12,13,14)}))
    list.append(("BW - Deep Thought","FBS",{'invertible':True,'direction':-1,'radius':2,'spinspeed':8,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(10,11,12,13,14,15,16,18,19)}))
    list.append(("SHW - Plural Zone","FBS",{'invertible':True,'direction':-1,'radius':2,'spinspeed':8,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(21,22,23,24,36,37,38,39,40,41,42,43)}))
