import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)

    # 0 - Vertical Spinner 1 - 123STW
    list.append(("Star Dust","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("Second Sunrise","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("Cash Cow","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("SHW - Holy Cow","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("WreckTangle 2","Rammer",{'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4}))

    # 1 - Vertical Spinner 2 - 123STW
    list.append(("LW - Wide VS","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
    list.append(("MW - Wide VS","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
    list.append(("Candy Bar","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
    list.append(("SHW - Root Beer","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))

    # 2 - Drum - 123STW
    list.append(("LW - Drum","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':3,'weapons':(0,)}))
    list.append(("MW - Wide Drum","Omni",{'invertible':True,'nose':math.pi*1,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':3,'weapons':(0,)}))
    list.append(("HW - Frequency","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':3,'weapons':(0,)}))
    list.append(("SHW - Widest Drum","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':3,'weapons':(0,)}))

    # 3 - SnS - 123STW
    list.append(("Accretion-Powered Pulsar","FBSInvertDir",{'spinspeed':18,'direction':-1,'tickFactor':10, 'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("Core Collapse Supernova","FBSInvertDir",{'spinspeed':50,'tickFactor':10,'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("Rotation-Powered Pulsar","FBSInvertDir",{'spinspeed':15,'tickFactor':10,'direction':1, 'invertible':True,'nose':math.pi*0.25,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("SHW - Quasar 1.7","FBSInvertDir",{'spinspeed':15,'tickFactor':10,'direction':1, 'invertible':True,'nose':math.pi*0.25,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))

    # 4 - SnS 2 -123STW
    list.append(("LW - Flail SnS","FBSInvertDir",{'spinspeed':14,'direction':-1,'tickFactor':10, 'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("MW - Flail SnS","FBSInvertDir",{'spinspeed':18,'direction':1,'tickFactor':10, 'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("DPS Generator 2.1","FBSInvertDir",{'spinspeed':14,'invertible':True,'nose':math.pi*0.25,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':20,'weapons':(0,)}))
    list.append(("SHW - Death Star 3","FBSInvertDir",{'spinspeed':15,'direction':1,'tickFactor':10, 'invertible':True,'nose':math.pi*0.1,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))

    # 5 - Popup 1 - 123STW
    list.append(("LW - Popup","Popup",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("MW - Popup","Popup",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("HW - Popup","Popup",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("SHW - Popup","Popup",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))

    # 6 - Spike Heads "I'd like you to meet my big metal friend..."
    list.append(("Calamity","Popup",{'nose':math.pi,'radius':0.1,'throttle':130,'topspeed':99,'turn':60,'turnspeed':5,'weapons':(1,)}))
    list.append(("Critical Damage","Popup",{'nose':math.pi,'radius':0.1,'throttle':130,'topspeed':99,'turn':60,'turnspeed':5,'weapons':(1,)}))
    list.append(("Beautiful Oblivion","Popup",{'nose':math.pi,'radius':0.1,'throttle':130,'topspeed':99,'turn':60,'turnspeed':5,'weapons':(1,)}))
    list.append(("SHW-Shiva","Popup",{'nose':math.pi,'radius':0.1,'throttle':130,'topspeed':99,'turn':60,'turnspeed':5,'weapons':(1,)}))

    # 7 - Gutripper - 123STW
    list.append(("Small Rat","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("Medium Rat","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("Fat Rat 2.71","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("SHW - King Rat 2","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))

    # 8 - De-Weapon - 123STW
    list.append(("Small Fish","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
    list.append(("Sting Ray","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':4,'weapons':(0,)}))
    list.append(("Antenna","FBSInvertDir",{'spinspeed':15,'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':20,'weapons':(0,)}))
    list.append(("SHW - De Weapon","FBSInvertDir",{'spinspeed':13,'direction':-1,'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':20,'weapons':(0,)}))

    # 9 - Team HEX "We eat nuts and bolts for breakfast."
    list.append(("High-Density Molecule","OmniRam",{'invertible':True,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,)}))
    list.append(("Negative Impact","Pinner",{'invertible':True,'radius':0.1,'throttle':130,'topspeed':99,'turn':50,'turnspeed':3,'weapons':(1,2,3,4)}))
    list.append(("ReFraction","Pinner",{'invertible':True,'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':3,'weapons':(55,)}))
    list.append(("SHW-Infinitude","Pinner",{'invertible':True,'radius':2,'topspeed':100,'throttle':100,'turn':30,'turnspeed':3,'weapons':(55,)}))

    # 10 - Team Z "Still cooler than you."
    list.append(("HMX","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("RDX","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("Wheel of Misfortune 2","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("Sagaris","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'throttle':150,'topspeed':99,'turn':60,'turnspeed':3,'weapons':(0,)}))

    # 11 - Shell Spinner - Urjak
    list.append(("Bane Revolution II","FBSPlus",{'nose':math.pi*2.5,'spinspeed':0,'direction':-1,'tickFactor':10, 'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':99,'weapons':(26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,61,62,63,64,65,66,67,68,69,70)}))  
    list.append(("Circle of Thorns VII","FBSPlus",{'nose':math.pi*1,'spinspeed':0,'direction':-1,'tickFactor':10, 'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':99,'weapons':(26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,61,62,63,64,65,66,67,68,69,70)})) 
    list.append(("Weapon Array V","FBSPlus",{'nose':math.pi,'spinspeed':0,'direction':-1,'tickFactor':10, 'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':99,'weapons':(26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,61,62,63,64,65,66,67,68,69,70)}))
    list.append(("SHW- Wreaking Havok","FBSPlus",{'nose':math.pi*2,'spinspeed':0,'direction':-1,'tickFactor':10, 'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':99,'weapons':(26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,61,62,63,64,65,66,67,68,69,70)}))

    
    
    # 12 - Face Spinner - 123STW
    list.append(("LW - Face Spinner","Drum",{'invertible':True,'nose':math.pi*1.5,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("MW - Face Spinner","Drum",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("HW - Face Spinner","Drum",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("SHW - Face Spinner","Drum",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':80,'turnspeed':3,'weapons':(0,)}))

    # 13 - Wide FS - 123STW
    list.append(("Milk Shake","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("MW - Wide FS","Drum",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':3,'weapons':(0,)}))
    list.append(("HW - Wide FS","Drum",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':3,'weapons':(0,)}))
    list.append(("SHW - Wide FS","Drum",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':30,'turnspeed':3,'weapons':(0,)}))

    # 14 - Crawler - 123STW
    list.append(("LW - Crawler","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("MW - Crawler","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("HW - Crawler","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))
    list.append(("SHW - Crawler","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.5,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(0,)}))

    #15 - SnSnS - 123STW
    list.append(("LW - SnSnS","FBSInvertDir",{'spinspeed':12,'direction':1,'tickFactor':10, 'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("MW - SnSnS","FBSInvertDir",{'spinspeed':16,'direction':1,'tickFactor':10, 'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("HW - SnSnS","FBSInvertDir",{'spinspeed':14,'direction':-1,'tickFactor':10, 'invertible':True,'nose':math.pi*0.5,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))
    list.append(("SHW - SnSnS","FBSInvertDir",{'spinspeed':18,'direction':1,'tickFactor':10, 'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':150,'throttle':130,'turn':100,'turnspeed':99,'weapons':(0,)}))

    #16 - Torque Reaction Drum - 123STW
    list.append(("LW - Big Wheel","TRFBD",{'invertible':True,'range':5,'radius':1,'topspeed':99,'throttle':100,'turn':100,'turnspeed':1,'weapons':(0,)}))
    list.append(("MW - Big Wheel","TRFBD",{'invertible':True,'range':5,'radius':1,'topspeed':99,'throttle':100,'turn':100,'turnspeed':1,'weapons':(0,)}))
    list.append(("HW - Big Wheel","TRFBD",{'invertible':True,'range':5,'radius':1,'topspeed':99,'throttle':100,'turn':100,'turnspeed':1,'weapons':(0,)}))
    list.append(("SHW - Big Wheel","TRFBD",{'invertible':True,'range':5,'radius':1,'topspeed':99,'throttle':100,'turn':100,'turnspeed':1,'weapons':(0,)}))