from __future__ import generators
import plus
import Arenas
import Hazards
import random

import math

class RingArena(Arenas.SuperArena):
    "It's all in your head...."
    name = "The VaporZone"
    preview = "vaporwave/vapor_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-20, 20, 20, -20)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/vaporwave/vaporzone.gmf")
        plus.setBackColor(0, 0, 0)
        
        self.players = ()
        
        fmod = .015
        # static cameras
        #self.AddStaticCamera("Static 1", (-3.5, 9, -7.7), (math.pi / 6.0, 0), math.pi / 4.0)
        #first tuple is xyz, second is i think camera yaw and pitch, third is the fov in degrees * 0.015
        self.AddStaticCamera("Static 1", (0, 60, 0), (1.57, 0), fmod*50)
        self.AddStaticCamera("Static 2", (30, 43, -30), (0.768, -0.785), fmod*50)
        #self.AddStaticCamera("Static 2", (0, 48, 0), (math.pi/2.01, 0), fmod*37)
        #self.AddStaticCamera("Static 3", (0, 13, -26), (.524, 0), fmod*52)
        
        # watch camera
        #self.AddWatchCamera("Watch 1", (-12.1, 9.8, -11.7), (2.0, 20.0, math.pi / 3.5, math.pi / 9.0))
        self.AddWatchCamera("Watch 1", (20, 25, -20), (2, 20, fmod*60, fmod*25))
        
    def AddShadowReceivers(self):
        pass
        
    def HazardsOn(self, on):
        return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):    
        if on: self.players = plus.getPlayers()
        return Arenas.SuperArena.Activate(self, on)
        
    def Introduction(self):
        sounds = self.intro_sounds
        
        # set initial camera & fade from black
        plus.setCameraPosition(-45,35,-45)
        plus.setCameraRotation(0.4012, 0.78539)
        plus.setCameraFOV(0.7753)
        plus.fadeFromBlack(.25)

        #start playing music loop
        self.intro_music = plus.createSound("Sounds/intro_music/smell_glue.wav", False, (0,0,0))
        plus.setVolume(self.intro_music, 0, 0)
        plus.loopSound(self.intro_music)
        yield .25
        
        #load all sounds now to decrease lag later
        sounds['crowd'] = plus.createSound("Sounds/crowd/LoudCheer_Loop.wav", False, (0,0,0))
        
        arenaOpt = ("Sounds/announcers/Arena_CombatZone.wav", "Sounds/announcers/Arena_Combat_Enter.wav")
        sounds['arena'] = plus.createSound(random.choice(arenaOpt), False, (0,0,0))
        genericOpt = ("Arena_Combat_CageOfSteel.wav", "Arena_NowhereToHide.wav", "Intro_TheFansAreReady.wav", "Intro_GreatMatchComingYourWay.wav", "Intro_FansAreRestless.wav", "Intro_PerfectEveningForDestruction.wav", "Intro_HoldOnToYourSeats.wav", "Misc_CrowdOnEdge.wav")
        sounds['generic'] = plus.createSound("Sounds/announcers/"+random.choice(genericOpt), False, (0,0,0))
        botOpt = ("Bots_YouCanFeelTension.wav", "Bots_ColdChill.wav", "Bots_FansLoveTheseBots.wav", "Bots_SeeingInterestingDesigns.wav", "Bots_CrowdPoisedBotsArmed.wav")
        sounds['bots'] = plus.createSound("Sounds/announcers/"+random.choice(botOpt), False, (0,0,0))
        
        #intro cam, welcom comment
        plus.playSound(sounds['arena'])
        plus.fadeInToLoop(sounds['crowd'], -100, 800)
        plus.animateCamera((-45,35,-45), (0.4012, 0.78539), 0.7753, (45,35,-45), (0.4012, -0.78539), 0.7753, 0, 8)
        yield 2
        plus.fadeOutLoop(sounds['crowd'], 8000)
        yield 1
        
        #play a generic (or specific) secondary comment
        plus.playSound(sounds['generic'])
        yield 5

        pcount = len(self.players)
        if pcount>0: plus.playSound(sounds['bots'])
        delaytime = 6 - pcount
        
        if 0 in self.players:
            #bot 1 cam
            plus.animateCamera((10,20,0), (0.533,-1.57), 0.6, (10,20,0), (0.533,-1.57), 0.45, 0, delaytime)
            yield delaytime
            
        if 1 in self.players:
            #bot 2 cam
            plus.animateCamera((-10,20,0), (0.533,1.57), 0.6, (-10,20,0), (0.533,1.57), 0.45, 0, delaytime)
            yield delaytime
            
        if 2 in self.players:
            #bot 3 cam
            plus.animateCamera((0,20,-10), (0.533,0), 0.6, (0,20,-10), (0.533,0), 0.45, 0, delaytime)
            yield delaytime
            
        if 3 in self.players:
            #bot 4 cam
            plus.animateCamera((0,20,10), (0.533,3.14), 0.6, (0,20,10), (0.533,3.14), 0.45, 0, delaytime)
            yield delaytime
            
        #fade out music
        plus.fadeOutLoop(self.intro_music, 2000)
        yield 2
        
        # done
        yield 0
        
    def Tick(self):
        for each in self.players:
            if plus.getLocation(each)[1] < -2:
                plus.eliminatePlayer(each)        
        return Arenas.SuperArena.Tick(self)

    def ZoneEvent(self, direction, id, robot, chassis):            
        return True

Arenas.register(RingArena)
