
import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)

    # 0 - Spin Doctors "We'll make you a smash hit!"
    list.append(("Tempus Fugit","Omni",{'invertible':True,'nose':math.pi,'topspeed':99,'throttle':130,'range':30,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Fury","Omni",{'invertible':True,'nose':math.pi,'topspeed':100,'throttle':140,'turnspeed':3.5,'range':35,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28)}))
    list.append(("Maelstrom","OmniRam",{'invertible':True,'radius':0.5,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'range':30,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52)}))
    list.append(("AW-Logic Probe","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turnspeed':3.5,'range':99,'weapons':(1,)}))
    list.append(("BW-Graviton","OmniRam",{'invertible':True,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3)}))
    list.append(("Spin Doctor","Omni",{'invertible':True,'nose':math.pi/2,'range':30,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30)}))

    # 1 - Alien Invasion "They're here!"
    list.append(("Drone","Pusher",{'invertible':True,'radius':0.05,'topspeed':99,'throttle':130,'turn':40,'turnspeed':1.5}))
    list.append(("Praetorian","Omni",{'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Alien Queen","Omni",{'topspeed':99,'throttle':130,'range':25,'weapons':(1,2,3,4,5,6,7,8,9,10)}))
    list.append(("AW-Chest Burster","Flipper",{'nose':math.pi/2,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,)}))
    list.append(("BW-Facehugger","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':20,'turnspeed':1}))
    list.append(("Predator","OmniRam",{'invertible':True,'topspeed':99,'throttle':130,'turnspeed':1.5,'turn':30,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)}))

    # 2- The PIT "Paragon Institute of Technology"
    list.append(("Poptart","Flipper",{'radius':0.5,'nose':math.pi/2,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("Ultraviolet","Poker",{'invertible':True,'topspeed':99,'throttle':130,'radius':0.1,'turnspeed':3.5,'turn':55,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("Vortex CE","DirectionalSpinner",{'invertible':True,'topspeed':99,'throttle':130,'radius':0.1,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13)}))
    list.append(("AW-VR Rino","Pusher",{'invertible':True,'nose':math.pi/2,'radius':0.1,'topspeed':99,'throttle':130,}))
    list.append(("BW-Bird of Prey","Spinner",{'nose':-math.pi/2,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3)}))
    list.append(("Rabid Pit Bull","Omni",{'invertible':True,'radius':0.8,'topspeed':99,'throttle':130,'turnspeed':3,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23)}))

    # 3 - SECOM Security Services "30 years experience in mobile robotics"
    list.append(("Sentinel Observer","DirectionalSpinner",{'radius':0.1,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3)}))
    list.append(("Intruder Alert","Omni",{'invertible':True,'nose':math.pi,'range':99,'topspeed':99,'throttle':130,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))
    list.append(("Tempest Exterminator","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22)}))
    list.append(("AW-Halt, who goes there?","Bee",{'invertible':True,'nose':math.pi,'whip':"around",'range':25,'radius':0.1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':5,'weapons':(1,2,3,4,5)}))
    list.append(("BW-None Shall Pass","Bee",{'invertible':True,'whip':"around",'range':25,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Lethal Force","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14,15,16,17,18)}))

    # 4 - Three Billy Goats Gruff "We eat anything and everything!"
    list.append(("Billy Goat Gruff","Omni",{'invertible':True,'radius':0.5,'topspeed':99,'throttle':130,'range':99,'weapons':(16,17,18,19)}))
    list.append(("Billy Goat Gruffier","Omni",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':99,'throttle':130,'range':99,'weapons':(16,17,18,19,20,21,22,23)}))
    list.append(("Billy Goat Gruffiest","Omni",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':99,'throttle':130,'turn':40,'turnspeed':2.0,'range':99,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))
    list.append(("AW-Billy the Kid","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'topspeed':99}))
    list.append(("BW-Billy Goat Gruffy","Omni",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':99,'throttle':130,'range':99,'weapons':(16,17)}))
    list.append(("The Troll","Omni",{'invertible':True,'radius':0.5,'topspeed':99,'throttle':130,'range':99,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))
   
    # 5 - Orbital Launch Team "How's the view from up there?!"
    list.append(("Sub-Orbital","Flipper",{'radius':0.1,'nose':math.pi,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("Launch Platform One","Omni",{'radius':0.5,'nose': math.pi,'topspeed':99,'throttle':130,'turn':50,'weapons':(16,17,18,19,20,21)}))
    list.append(("Orbital Delivery Vehicle","Omni",{'nose': math.pi,'turn':20,'turnspeed':1.75,'topspeed':99,'throttle':130,'range':99,'weapons':(16,17,18,19,20,21)}))
    list.append(("AW-Launch Platform Zero","Flipper",{'radius':0.1,'nose':math.pi,'topspeed':99,'throttle':130,'weapons':(1,)}))
    list.append(("BW-Stratosphere","Flipper",{'nose':math.pi/2,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("3-2-1 Blastoff!","Omni",{'radius':0.1,'nose':math.pi,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34)}))

    # 6 - Team Jabberwocky "'Twas brillig, and the slithy toves, did grye and gimble in the wabe..."
    list.append(("Jubjub Bird","Omni",{'radius':1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':3,'weapons':(27,28,29,30)}))
    list.append(("Bandersnatch","Poker",{'nose': math.pi/2,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Jabberwock","Omni",{'nose': math.pi/2,'radius':0.5,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40)}))
    list.append(("AW-Vorpal Bunny","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("BW-Slithy Tove","Poker",{'radius':0.5,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("Mome Rath","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14)}))

    # 7 - The Sheep Squad "Baaaaa, Ram, Ewe!"
    list.append(("Battering Lamb","Poker",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14,15)}))
    list.append(("Battering Ewe","Poker",{'invertible':True,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22)}))
    list.append(("Battering Ram","Poker",{'invertible':True,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34)}))
    list.append(("AW-The Shepard","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("BW-Wolf in Sheep's Clothing","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,10)}))
    list.append(("Flying Sheep","Flyer",{'topspeed':99,'throttle':130,'turn':100,'turnspeed':99,'range':99,'radius':0,'proximity':20,'weapons':(1,2,3,4,5,6,7,8,9,11,12)}))

    # 8 - SkyNET "Are you Sarah Conner?!"
    list.append(("Aerial HK","Spinner",{'nose':math.pi,'range':30,'topspeed':99,'throttle':130,'weapons':(1,2,3)}))
    list.append(("T-400 Infiltrator","Omni",{'invertible':True,'range':30,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("Hunter-Killer Tank","Omni",{'nose':math.pi,'range':30,'topspeed':50,'throttle':50,'turn':30,'turnspeed':2,'radius':0.1,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35)}))
    list.append(("AW-T-125 Burger Flipper","Flipper",{'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("BW-Mini-Hunter","Spinner",{'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3)}))
    list.append(("T-800 Terminator","Omni",{'invertible':True,'topspeed':99,'throttle':130,'turn':100,'turnspeed':3,'range':99,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39)}))

    # 9 - Borg Collective "We are the Borg. Resistance is futile."
    list.append(("Eagle Borg Scout","Omni",{'invertible':True,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4)}))
    list.append(("Borg Drone","Spinner",{'nose':math.pi,'turnspeed':1.5,'topspeed':99,'throttle':130,'range':99,'weapons':(16,17,18,19,20,21,22,23,24)}))
    list.append(("Borg Queen","Spinner",{'nose':math.pi,'range':99,'topspeed':99,'throttle':130,'weapons':(16,17,18,19,20,21,22,24,25,26,27,28,29,30,31,32,33,34)}))
    list.append(("AW-Borgette","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("BW-Gravitic Mine","Spinner",{'invertible':True,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("SHW-Locutus of Borg","Omni",{'radius':.1,'nose':-math.pi/2,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46)}))

    # 10 - Eye of the Storm "We'll tear you apart!"
    list.append(("Cyclone","Omni",{'invertible':True,'nose':math.pi/2,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3)}))
    list.append(("Hurricane","Bee",{'invertible':True,'whip':"around",'nose':math.pi/2,'range':25,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6)}))
    list.append(("Jupiter","Bee",{'invertible':True,'nose':math.pi,'whip':"around",'range':25,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))
    list.append(("AW-Whirlwind","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(1,)}))
    list.append(("BW-Tsunami","Pusher",{'invertible':True,'radius':0,'turn':30,'turnspeed':1.0,'topspeed':99,'throttle':130}))
    list.append(("Tidalwave","Omni",{'invertible':True,'nose':-math.pi/2,'radius':0.5,'topspeed':99,'throttle':130,'range':99,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39)}))

    # 11 - The Gravediggers "R.I.P. - Rest In Pieces"
    list.append(("Reaper","Omni",{'invertible':True,'range':99,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6)}))
    list.append(("Pandora's Box","Poker",{'invertible':True,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(1,2,3)}))
    list.append(("Death Cloud","Omni",{'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))
    list.append(("AW-Zombie","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("BW-Ghoul","Flipper",{'radius':0.5,'topspeed':99,'throttle':130,'weapons':(1,)}))
    list.append(("Leprosy","Omni",{'invertible':True,'nose':math.pi,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26)}))

    # 12 - King Arthur's Court "Might makes right!"
    list.append(("Castle Guard","Whipper",{'invertible':True,'whip':"around",'radius':1.0,'topspeed':99,'throttle':130,'turn':100,'turnspeed':5.0,'weapons':(16,)}))
    list.append(("Man-at-Arms","Omni",{'invertible':True,'topspeed':99,'throttle':130,'turnspeed':3.5,'range':99,'weapons':(16,17,18,19,20,21)}))
    list.append(("Lancelot","Poker",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':99,'throttle':130,'turn':100,'turnspeed':4,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20)}))
    list.append(("AW-BattleANT","Bee",{'invertible':True,'whip':"around",'range':25,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':100,'turnspeed':5,'weapons':(16,17)}))
    list.append(("BW-Squire","Poker",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,)}))
    list.append(("Black Knight","Omni",{'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24)}))

    # 13 - Team Atlantis "Up from the murky deeps we rise..."
    list.append(("Whirlpool","Bee",{'invertible':True,'whip':"around",'range':20,'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(1,2,3,4)}))
    list.append(("Tentacle Attack","Flipper",{'topspeed':99,'throttle':130,'weapons':(1,2,3,4)}))
    list.append(("Kraken","Poker",{'invertible':True,'radius':0.5,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14,15,16,17,18)}))
    list.append(("AW-Riptide","Pusher",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("BW-Piranha","Poker",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("Ancient Leviathan","Poker",{'invertible':True,'topspeed':99,'throttle':130,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))

    # 14 - Acme Moving Men "Look what fell off the truck! Hey, how do you turn this thing on?"
    list.append(("Scrap Box","Pusher",{'invertible':True,'nose':math.pi/2,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':1.5}))
    list.append(("Caution: Hazardous Contents","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':1.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("Express Delivery","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14)}))
    list.append(("AW-Wooden Box on a Stick","Pusher",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,}))
    list.append(("BW-Nail Gun","Pusher",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':10,'turnspeed':1.5}))
    list.append(("Battlebox","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))

    # 15 - Rust Factory "Brought to you by Rejected"
    list.append(("Reckless Infiltrator","Poker",{'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14)}))
    list.append(("Acrid","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14)}))
    list.append(("Clockwork Hydra","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24)}))
    list.append(("AW-Expendable Automation","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("Vox","Bee",{'whip':"around",'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("Neglected Waterbug","Omni",{'topspeed':99,'throttle':130,'radius':0.1,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23)}))

    # 16 - Grandpa's Shed "Brought to you by Clutch"
    list.append(("Robo Rake","Omni",{'invertible':True,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6)}))
    list.append(("Bucket of Nails","Spinner",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20)}))
    list.append(("Wide Cut","Omni",{'nose':math.pi,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24)}))
    list.append(("AW-Old Tin Can","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("BW-Tiny Tetanus","Poker",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(16,17,18)}))
    list.append(("Shedenator","Omni",{'nose':math.pi,'range':35,'topspeed':99,'throttle':130,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))

    # 17 - ACAMS Cleaning Service "Brought to you by ACAMS"
    list.append(("Duster","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,10,11,12)}))
    list.append(("Sweeper","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,10,11,12,13,14,15,16)}))
    list.append(("Street Sweeper","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32)}))
    list.append(("AW-Wisk Broom","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,}))
    list.append(("BW-Scrubber","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,10)}))
    list.append(("Industrial Sanitizer","Omni",{'invertible':True,'range':30,'topspeed':99,'throttle':130,'turn':100,'turnspeed':6,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56)}))

    # 18 - Spam! Spam! Spam! "Brought to you by Diablo"
    list.append(("Click Me!","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':99,'turnspeed':4,'weapons':(1,2,3,4)}))
    list.append(("Win! Win! WIN!","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2)}))
    list.append(("Spaminator 2: Judgement Day","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(1,2,3,4)}))
    list.append(("Ad-Aware","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("BW-Lose More Weight!","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4)}))
    list.append(("Ultimate Spammer","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(1,2,3,4,5,6)}))

    # 19 - 1337 SPEEKERS "Brought to you by Eyce"
    list.append(("Uber-1337","Spinner",{'topspeed':99,'throttle':130,'range':99,'weapons':(16,17,18,19,20,21)}))
    list.append(("1337: Breakdown","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(9,10,11,12,13,14,15)}))
    list.append(("1337 Speek 2.0","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2}))
    list.append(("AW-IBK-Idiot Behind Keyboard","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("BW-Bann3d","Poker",{'radius':0.1,'topspeed':99,'throttle':130,'weapons':(9,)}))
    list.append(("Alpha","Poker",{'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(9,10,11,12,13)}))

    # 20 - Infestation "Brought to you by Foolishevil"
    list.append(("Blood Leech","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6)}))
    list.append(("RoAcH","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14)}))
    list.append(("Insectoid","Omni",{'radius':0.8,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("Aedes","Omni",{'radius':0.1,'range':99,'topspeed':99,'throttle':130,'range':99,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Scabies","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("Papa Roach","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26)}))

    # 21 - C2 Robotics "Brought to you by C2"
    list.append(("Black Bull","Poker",{'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2)}))
    list.append(("Mutiny II","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5)}))
    list.append(("Rebel 2","Poker",{'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5)}))
    list.append(("AW-Rebel","Pusher",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,)}))
    list.append(("BW-Rhino","Poker",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,)}))
    list.append(("Anti Epic","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7)}))

    # 22 - EHB "Brought to you by Spawngeek"
    list.append(("Wee VS","Omni",{'topspeed':99,'throttle':130,'turn':35,'turnspeed':3,'range':99,'weapons':(1,2,3,4,5)}))
    list.append(("Happy Returns","Omni",{'radius':0.1,'range':99,'topspeed':99,'throttle':130,'turn':20,'turnspeed':3,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))
    list.append(("Spikefan","Omni",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28)}))
    list.append(("Octomini Xtreme","Omni",{'invertible':True,'nose':math.pi/2,'radius':0.1,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("Chopsticks","Omni",{'radius':0.1,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))
    list.append(("Little Darling","Omni",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))

    # 23 - Carnival Mayhem "Brought to you by Foolishevil"
    list.append(("Bitter Box","Spinner",{'nose':math.pi,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6)}))
    list.append(("Box of Pure Evil","Bee",{'range':99,'whip':"around",'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Infernium","Poker",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))
    list.append(("Crimson Fury Xtreme","Poker",{'topspeed':99,'throttle':130,'turn':100,'turnspeed':99,'range':99,'radius':0,'weapons':(1,2,3,4,5,6,7,8,9,11,12)}))
    list.append(("Mr. Hell","DirectionalSpinner",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24)}))
    list.append(("Cideous","Omni",{'radius':0.1,'topspeed':50,'throttle':50,'turn':30,'turnspeed':2,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)}))

    # 24 - Team XORB "Brought to you by Jimxorb"
    list.append(("Phale","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2)}))
    list.append(("XZAI 2","Poker",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6)}))
    list.append(("Ranacide 3","Omni",{'radius':0.1,'topspeed':99,'throttle':130}))
    list.append(("Matanca 2","DirectionalSpinner",{'invertible':True,'nose':math.pi,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6)}))
    list.append(("Jyro","Omni",{'invertible':True,'nose':math.pi,'topspeed':99,'throttle':130}))
    list.append(("SHW-Warlock","Poker",{'radius':1,'topspeed':99,'throttle':130,'turnspeed':4,'turn':100,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)}))

    # 25 - Mythbots "Brought to you by Viper"
    list.append(("Anubis","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':1}))
    list.append(("Orcus","OmniRam",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':1}))
    list.append(("Osiris","Pusher",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':1}))
    list.append(("Loki","Omni",{'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turnspeed':3,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("BW- Odin","Omni",{'nose':math.pi,'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turnspeed':3,'weapons':(1,2,3)}))
    list.append(("Poseidon","Omni",{'nose':math.pi,'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turnspeed':3,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13)}))

    # 26 - Team Ultimatum "Brought to you by EpicentrE"
    list.append(("Zenith","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3)}))
    list.append(("12xrt","Omni",{'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("Epic","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14)}))
    list.append(("Epic Jr.","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'range':99,'weapons':(1,2,3,4,5,6)}))
    list.append(("Synergy","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(1,2,3,4)}))
    list.append(("Void","Omni",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19)}))

    # 27 - Team Emergency "Brought to you by WardenX"
    list.append(("Breakout","Spinner",{'invertible':True,'nose':math.pi,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6)}))
    list.append(("Emergency Fly-By","OmniRam",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("Final Operation","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)}))
    list.append(("Blades of Life","Omni",{'invertible':True,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6)}))
    list.append(("Emergency Launch","Omni",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(1,2,3)}))
    list.append(("Fatal Incision","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(1,2,3,4,5,6,7)}))

    # 28 - Wedge Elimination Specialist "Brought to you by ACAMS"
    list.append(("Childs Play  IV","Omni",{'invertible':True,'topspeed':99,'throttle':130,'range':30,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Death Trap","Omni",{'invertible':True,'topspeed':99,'throttle':130,'range':30,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("WedgeWhacker ","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("AW-Wedge X","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3)}))
    list.append(("BW-Wedge Y","Poker",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4)}))
    list.append(("SHW-Alligator","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':100,'turnspeed':9,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,129,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50)}))

    # 29 - Happy Bees "Brought to you by Rejected"
    list.append(("The Odd Bee","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("Dizzy Bees","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))
    list.append(("Bee Keeper","Bee",{'invertible':True,'nose':math.pi,'whip':"around",'radius':0.1,'range':99,'topspeed':99,'throttle':130,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32)}))
    list.append(("Exploding Bees","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13)}))
    list.append(("Robotic Bee","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14)}))
    list.append(("The Possessed Bee","Omni",{'invertible':True,'range':99,'topspeed':99,'throttle':130,'turn':50,'turnspeed':6,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17)}))

    # 30 - Spinners of Doom "Brought to you by ACAMS"
    list.append(("Jason","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':100,'turnspeed':4,'weapons':(1,2,3,4,5,6,7,8,9)}))
    list.append(("Death Warrant","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,17,18,19,20,21,22,23,24,25,26,27)}))
    list.append(("2 Sinister","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29)}))
    list.append(("Texas Twister","Bee",{'radius':0.1,'whip':"around",'range':30,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28)}))
    list.append(("Abrupt Decision","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29)}))
    list.append(("SHW-EBOLA","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':100,'turnspeed':6,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29)}))

    # 31 - Past-Present-Future "Brought to you by Artitan"
    list.append(("Tick Tock","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(1,2,3,4)}))
    list.append(("Green Time Vortex","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("The Bloody Pendulum","Omni",{'nose':math.pi/2,'radius':0.1,'range':99,'topspeed':99,'throttle':130,'turn':30,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11)}))
    list.append(("Inside the Clock","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11)}))
    list.append(("Time Pixie","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22)}))
    list.append(("SHW-Cactus Jack","Pusher",{'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':1}))

    # 32 - Team SpaceStation "Brought to you by Gemini"
    list.append(("Orion's Fury","Omni",{'invertible':True,'radius':0.1,'nose':math.pi,'topspeed':99,'throttle':130,'range':99,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6)}))
    list.append(("Critical Contact","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2}))
    list.append(("Alien Predator","Omni",{'invertible':True,'radius':0.1,'nose':math.pi,'range':99,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20)}))
    list.append(("Air Supply","Omni",{'radius':0.1,'nose':math.pi,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2)}))
    list.append(("Max Power","Omni",{'radius':0.1,'range':99,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2)}))
    list.append(("Meteor","Omni",{'radius':0.1,'nose':math.pi,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12)}))

    # 33 - The Mafia "Brought to you by Clutch"
    list.append(("Button Man","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6)}))
    list.append(("Dirty Money","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8)}))
    list.append(("Tommy Gun","Omni",{'radius':0.1,'range':99,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42)}))
    list.append(("AW-Johnny Law","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("BW-Get Away Car","Pusher",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("The Don","Pusher",{'invertible':True,'radius':0.1,'nose':math.pi,'topspeed':99,'throttle':130,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)}))

    # 34 - Team Karnage "Brought to you by Karnage"
    list.append(("Klip","Omni",{'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':50,'turnspeed':2,'weapons':(1,2,3)}))
    list.append(("Mini Karnage","Omni",{'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'range':99,'turn':50,'turnspeed':2,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("Karnage","Omni",{'invertible':True,'radius':0.1,'range':99,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)}))
    list.append(("AW-Knat Bite","Pusher",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("BW-Big Knat Bite","Pusher",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Super Karnage","Omni",{'invertible':True,'radius':0.1,'range':99,'topspeed':99,'throttle':130,'turn':60,'turnspeed':2.6,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14)}))