from __future__ import generators
import plus
import Arenas
import random
import Hazards2
import math

class ClawTop(Arenas.SuperArena):
    "WELCOME TO THE BATTLEBOX!!!!"
    name = "BATTLEBOX 2.0"
    preview = "BATTLEBOX_2_0/preview.bmp"
    game_types = ['DEATHMATCH']
    extent = (-13, 13, 14, -14)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/BATTLEBOX_2_0/arena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        
        fov = 0.015
        self.AddStaticCamera("Static Cam Overhead", (0, 30, -63), (1.5708,0), 72*fov)
	self.AddStaticCamera("Static Cam Angled Mega Zoom", (0, 60, -20), (2.17, 0), 25*fov)
	self.AddStaticCamera("Static Cam Angled Zoom", (0, 60, -20), (2.17, 0), 35*fov)
	self.AddStaticCamera("Static Cam Angled Zoom Out", (0, 60, -20), (2.17, 0), 45*fov)
	self.AddWatchCamera("Watch Cam Ultra Mega Zoom", (0, 60, -30), (6, 12, 30*fov, 10*fov))
	self.AddWatchCamera("Watch Cam Mega Zoom", (0, 60, -30), (6, 12, 30*fov, 20*fov))
	self.AddWatchCamera("Watch Cam Zoom", (0, 60, -30), (6, 12, 30*fov, 30*fov))
	self.AddWatchCamera("Watch Cam Zoom Out", (0, 60, -30), (6, 12, 30*fov, 40*fov))
	self.AddWatchCamera("Watch Cam Mega Zoom Out", (0, 60, -30), (6, 12, 30*fov, 50*fov))
        self.players = ()

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)


    def HazardsOn(self, on):
        if on:

            #RamRod stuff
            prism = self.AddPrismatic("Floor", "spikes", 0, 1, 0, 0, .8, 0)
            self.spikes1 = Hazards2.Spikes(prism, 80000, (-3.7, -2.2, -5.2))

            prism = self.AddPrismatic("Floor", "spikes01", 0, 1, 0, 0, .8, 0)
            self.spikes2 = Hazards2.Spikes(prism, 80000, (-3.7, -2.2, -5.2))

            self.AddHazard(self.spikes1)
            self.AddHazard(self.spikes2)

            self.RegisterZone("spike_zone",13)
            self.RegisterZone("spike_zone01",14)

            self.SetSubMaterialSound("hammer1", "metal", .8, "Sounds\\hzd_hammer_thud.wav")
            self.SetSubMaterialSound("hammer2", "metal", .8, "Sounds\\hzd_hammer_thud.wav")
        
            #Hellraiser stuff
            hinge = self.GetHinge("Hinge01")
            self.RegisterZone("hellzone1", 1)
            self.Hell1 = Hazards2.HellRaiser(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell1)
            
            hinge = self.GetHinge("Hinge02")
            self.RegisterZone("hellzone2", 2)
            self.Hell2 = Hazards2.HellRaiser(hinge, (-3.049, 0.0, -6.926))
            self.AddHazard(self.Hell2)

            #Hammers            
            hinge = self.GetHinge("hammerhinge1")
            self.RegisterZone("hammerzone1", 3)
            self.Hammer1 = Hazards2.HellRaiser(hinge, (-16.645, -80.815, -5.586))
            self.AddHazard(self.Hammer1)
            
            hinge = self.GetHinge("hammerhinge2")
            self.RegisterZone("hammerzone2", 4)
            self.Hammer2 = Hazards2.HellRaiser(hinge, (16.811, -80.453, -5.584))
            self.AddHazard(self.Hammer2)

            hinge = self.GetHinge("hammerhinge3")
            self.RegisterZone("hammerzone3", 5)
            self.Hammer3 = Hazards2.HellRaiser(hinge, (-16.645, -80.815, -5.586))
            self.AddHazard(self.Hammer3)
            
            hinge = self.GetHinge("hammerhinge4")
            self.RegisterZone("hammerzone4", 6)
            self.Hammer4 = Hazards2.HellRaiser(hinge, (16.811, -80.453, -5.584))
            self.AddHazard(self.Hammer4)
            
            #saw stuff to make them pop up
            hinge = self.GetHinge("saw_hinge")
            self.RegisterZone("saw_zone", 7)
            self.Hell3 = Hazards2.Saws(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell3)

            hinge = self.GetHinge("saw_hinge01")
            self.RegisterZone("saw_zone01", 8)
            self.Hell4 = Hazards2.Saws(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell4)

            hinge = self.GetHinge("saw_hinge02")
            self.RegisterZone("saw_zone02", 9)
            self.Hell5 = Hazards2.Saws(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell5)

            hinge = self.GetHinge("saw_hinge03")
            self.RegisterZone("saw_zone03", 10)
            self.Hell6 = Hazards2.Saws(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell6)

            hinge = self.GetHinge("saw_hinge04")
            self.RegisterZone("saw_zone04", 11)
            self.Hell7 = Hazards2.Saws(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell7)

            hinge = self.GetHinge("saw_hinge05")
            self.RegisterZone("saw_zone05", 12)
            self.Hell8 = Hazards2.Saws(hinge, (3.034, 0.0, -6.926))
            self.AddHazard(self.Hell8)

            #arena spinners
            self.spinner = self.GetHinge("spinner")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(20, 1000)
            self.spinner.Lock(False)
            self.spinner.SetDirection(-100)

            self.spinner2 = self.GetHinge("spinner2")
            self.spinner2.SetAutoLocks(False, True)
            self.spinner2.SetPowerSettings(20, 1000)
            self.spinner2.Lock(False)
            self.spinner2.SetDirection(-100)

            #saw stuff to make them spin
            self.sawspin = self.GetHinge("saws_spin")
            self.sawspin.SetAutoLocks(False, True)
            self.sawspin.SetPowerSettings(20, 1000)
            self.sawspin.Lock(False)
            self.sawspin.SetDirection(-100)

            self.sawspin2 = self.GetHinge("saws_spin01")
            self.sawspin2.SetAutoLocks(False, True)
            self.sawspin2.SetPowerSettings(20, 1000)
            self.sawspin2.Lock(False)
            self.sawspin2.SetDirection(-100)

            self.sawspin3 = self.GetHinge("saws_spin02")
            self.sawspin3.SetAutoLocks(False, True)
            self.sawspin3.SetPowerSettings(20, 1000)
            self.sawspin3.Lock(False)
            self.sawspin3.SetDirection(-100)

            self.sawspin4 = self.GetHinge("saws_spin03")
            self.sawspin4.SetAutoLocks(False, True)
            self.sawspin4.SetPowerSettings(20, 1000)
            self.sawspin4.Lock(False)
            self.sawspin4.SetDirection(-100)

            self.sawspin5 = self.GetHinge("saws_spin04")
            self.sawspin5.SetAutoLocks(False, True)
            self.sawspin5.SetPowerSettings(20, 1000)
            self.sawspin5.Lock(False)
            self.sawspin5.SetDirection(-100)

            self.sawspin6 = self.GetHinge("saws_spin05")
            self.sawspin6.SetAutoLocks(False, True)
            self.sawspin6.SetPowerSettings(20, 1000)
            self.sawspin6.Lock(False)
            self.sawspin6.SetDirection(-100)

        else:
            pass
        
        return Arenas.SuperArena.HazardsOn(self, on)

    def Tick(self):
        # check to see if anyone has been "eliminated" by falling into a pit
        for each in self.players:
            if plus.getLocation(each)[1] < -8 and not plus.isEliminated(each):
                plus.eliminatePlayer(each)
                
        if self.bHazardsOn:

            #activate hazards
            self.Hell1.Tick()
            self.Hell2.Tick()
            self.Hell3.Tick()
            self.Hell4.Tick()
            self.Hell5.Tick()
            self.Hell6.Tick()
            self.Hell7.Tick()
            self.Hell8.Tick()
            self.spikes1.Tick()
            self.spikes2.Tick()
            self.Hammer1.Tick()
            self.Hammer2.Tick()
            self.Hammer3.Tick()
            self.Hammer4.Tick()

        return Arenas.SuperArena.Tick(self)

    def ZoneEvent(self, direction, id, robot, chassis):
        #if people are in zones then make the hazards to stuff
        if (id==1 and direction==1):
            self.Hell1.RaiseHell()
        elif (id==2 and direction==1):
            self.Hell2.RaiseHell()
        elif (id==3 and direction==1):
            self.Hammer1.RaiseHell()
        elif (id==4 and direction==1):
            self.Hammer2.RaiseHell()
        elif (id==5 and direction==1):
            self.Hammer3.RaiseHell()
        elif (id==6 and direction==1):
            self.Hammer4.RaiseHell()
        elif (id == 7 and direction==1):
            self.Hell3.RaiseHell()
        elif (id == 8 and direction==1):
            self.Hell4.RaiseHell()
        elif (id == 9 and direction==1):
            self.Hell5.RaiseHell()
        elif (id == 10 and direction==1):
            self.Hell6.RaiseHell()
        elif (id == 11 and direction==1):
            self.Hell7.RaiseHell()
        elif (id == 12 and direction==1):
            self.Hell8.RaiseHell()
        elif (id == 13):
            # entering spikes zone 1
            self.spikes1.ZoneEvent(direction)
        elif (id == 14):
            # entering spikes zone 1
            self.spikes2.ZoneEvent(direction)

        return True
        
Arenas.register(ClawTop)
