import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)
    
    list.append( ("Aftershock", "Pusher", { 'turnspeed' : 1.0, 'invertible': True }) )
    list.append( ("Atomic Wedgie", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'invertible' : True }) )
    list.append( ("Backlash", "DirectionalSpinner", { 'nose' : math.pi, 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'turnspeed' : 1, }) )
    list.append( ("Center Punch", "Rammer", { 'invertible': True, 'turnspeed' : .7, 'nose' : math.pi }) )
    list.append( ("CODE: BLACK", "DirectionalSpinner", { 'invertible': True, 'nose': math.pi, 'trigger' : 'twirl', 'topspeed': 12.0, 'turnspeed': 2.0, 'throttle': 110, 'weapons': (4,), 'range' : 1000000 }) )
    list.append( ("Death By Monkeys", "Rammer", { 'turnspeed' : 1.0, 'invertible': True }) )
    list.append( ("Deathstar", "Spinner", { 'topspeed' : 10.0, 'throttle' : 110.0, 'weapons': (10, 13, 15, 17), 'range' : 1000000 }) )
    list.append( ("Diesector", "Chopper", { 'radius': 1.3, 'topspeed' : 12 , 'throttle' : 110 , 'turnspeed' : 1.25, 'weapons': (14, 15, 16, 17), 'trigger' : 'Fire' }) )
    list.append( ("Double Agent", "Rammer", { 'invertible': True, 'turnspeed' : .7 }) )
    list.append( ("Dreadnought", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'turnspeed' : 1, 'invertible': True }) )
    list.append( ("Dr Inferno Jr", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi }) )
    list.append( ("Final Destiny", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000 }) )
    list.append( ("Frostbite", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 50.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi, 'turnspeed' : 1, 'invertible': True }) )
    list.append( ("Garm", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi / 2, 'invertible' : True }) )
    list.append( ("GoldDigger", "Whipper", {  'invertible': True, 'whip': "around", 'zone': "weapon", 'turnspeed': 3, 'turn': 40, 'topspeed': 20.0, 'throttle': 400, 'weapons': (8,) }) )
    list.append( ("Hazard", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi }) )
    list.append( ("Heavy Metal Noise", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (17,), 'radius' : 2, 'trigger' : 'Spin', 'invertible': True, 'range' : 1000000 }) )
    list.append( ("HerrGepounden", "Whipper", { 'invertible': True, 'whip': "around", 'zone': "swing", 'turnspeed': 3, 'turn': 40, 'topspeed': 20.0, 'throttle': 400, 'weapons': (8,), 'nose' : math.pi }) )
    list.append( ("Hexy Jr", "Flipper", { 'topspeed' : 12.0, 'throttle' : 200, 'turnspeed': 2.0, 'weapons': (6,) }) )
    list.append( ("IceBerg", "Flipper", { 'topspeed' : 12.0, 'throttle' : 200, 'turnspeed': 2.0, 'weapons': (6,), 'invertible' : True, 'nose' : math.pi }) )
    list.append( ("Junkyard Dog v2.0", "DirectionalSpinner", { 'invertible': True, 'nose': math.pi, 'trigger' : 'twirl', 'topspeed': 12.0, 'turnspeed': 2.0, 'throttle': 110, 'weapons': (21, 22), 'range' : 1000000 }) )
    list.append( ("Killerhurtz", "Chopper", {  'radius': 1.3, 'topspeed' : 12 , 'throttle' : 110 , 'turnspeed' : 1.25, 'weapons': (14, 15), 'trigger' : 'Fire' }) )
    list.append( ("Knee Breaker", "DirectionalSpinner", { 'invertible' : True, 'turnspeed' : 1, 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000 }) )
    list.append( ("Little Drummer Boy", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'invertible' : True }) )
    list.append( ("Mad Cows Revenge", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'topspeed': 12.0, 'turnspeed': 2.0, 'throttle': 110, 'weapons': (8, 9), 'range' : 1000000 }) )
    list.append( ("Mauler 5150", "Spinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi / 2 }) )
    list.append( ("Mechavore", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000 }) )
    list.append( ("Minion", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'turnspeed' : 1, 'invertible': True }) )
    list.append( ("MOE", "DirectionalSpinner", { 'topspeed' : 8.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi }) )
    list.append( ("Moebius", "Spinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (10, 13, 15, 17), 'range' : 1000000 }) )
    list.append( ("Nightmare", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : - math.pi / 2 }) )
    list.append( ("Phrizbee Ultimate", "Spinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (10, 13, 15, 17), 'range' : 1000000 }) )
    list.append( ("Phrizbee", "Spinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (10, 13, 15, 17), 'range' : 1000000 }) )
    list.append( ("Shaft", "Pusher", { 'turnspeed' : 1.0, 'invertible': True, 'throttle' : 300 }) )
    list.append( ("Slam Job", "Chopper", {  'nose' : math.pi ,'radius': 1.3, 'topspeed' : 12 , 'throttle' : 110 , 'turnspeed' : 1.25, 'weapons': (14, 15), 'trigger' : 'Fire' }) )
    list.append( ("SO What", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (17,), 'radius' : 2, 'trigger' : 'Spin', 'range' : 1000000 }) )
    list.append( ("Son of Whyachi", "Spinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 3, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi }) )
    list.append( ("SnowFlake", "Rammer", { 'invertible': True, 'turnspeed' : .7, 'nose' : -math.pi / 2 }) )
    list.append( ("Surgeon General", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (17,), 'radius' : 2, 'trigger' : 'Spin', 'invertible': True, 'range' : 1000000 }) )    
    list.append( ("The Judge", "Chopper", {  'radius': 1.3, 'topspeed' : 12 , 'throttle' : 110 , 'turnspeed' : 1.25, 'weapons': (14, 15), 'trigger' : 'Fire', 'car': True }) )
    list.append( ("T-Minus", "Flipper", { 'topspeed' : 12.0, 'throttle' : 200, 'turnspeed': 2.0, 'nose' : math.pi, 'weapons' : (4,) }) )
    list.append( ("TORO", "Flipper", { 'topspeed' : 12.0, 'throttle' : 200, 'turnspeed': 2.0, 'weapons': (6,) }) )
    list.append( ("Turtle Road Kill", "Pusher", { 'turnspeed' : 1.0, 'invertible': False, 'throttle' : 300, 'nose' : math.pi, }) )
    list.append( ("T-Wrex", "Whipper", {  'invertible': True, 'whip': "around", 'zone': "spin", 'turnspeed': 3, 'turn': 40, 'topspeed': 20.0, 'throttle': 400, 'weapons': (8,), 'nose' : math.pi }) )
    list.append( ("Village Idiot", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3, 17), 'radius' : 3, 'trigger' : 'Spin', 'range' : 1000000, 'nose' : math.pi / 2 }) )
    list.append( ("Vladiator", "Flipper", { 'invertible': True, 'topspeed' : 12.0, 'throttle' : 110.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Flip' }) )
    list.append( ("Voltronic", "Flipper", { 'invertible': True, 'topspeed' : 12.0, 'throttle' : 90.0, 'weapons': (1, 2, 3), 'radius' : 2, 'trigger' : 'Flip', 'nose' : math.pi }) )
    list.append( ("Warhead", "Chopper", {  'radius': 1.3, 'topspeed' : 12 , 'throttle' : 110 , 'turnspeed' : 1.25, 'weapons': (14, 15), 'trigger' : 'Fire', 'nose' : math.pi }) )
    list.append( ("Ziggo", "Spinner", { 'topspeed' : 12.0, 'throttle' : 110.0, 'nose' : math.pi, 'range' : 10000000000000000000000000, 'weapons' : (10, 11) }) )    

