import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)
    
    list.append( ("Wedge", "Flipper", { 'weapons': (14,) }) )
    list.append( ("Shadow Spinner", "Whipper", { 'invertible': True, 'whip': "around", 'zone': "swing", 'turnspeed':110, 'turn':80, 'topspeed':120.0, 'throttle': 110, 'weapons':(14,) }) )
    list.append( ("Pound", "Pusher", { 'radius':1.5, 'turnspeed' : 1.5 }) )
    #list.append( ("Metal Muncher.", "LittleMetalFriend", {}) )
    list.append( ("Metal Muncher", "Poker", { 'invertible': True, 'weapons': (21, 22) }) )
    list.append( ("DJ Ray", "Rammer", { }) )
    list.append( ("Axe", "Chopper", { 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Battle Flipper", "Flipper", { 'invertible': True, 'nose': math.pi, 'weapons': (14,) }) )
    list.append( ("Vanquisher", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 200.0, 'turnspeed': 200.0, 'throttle': 200, 'weapons': (21, 22) }) )
    list.append( ("Shin Dragon", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("SSR-175", "Poker", { 'invertible': True, 'weapons': (21, 22) }) )
    list.append( ("Armadello", "DirectionalSpinner", { 'nose': math.pi, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    #list.append( ("The craine", "Chopper", { 'weapons' : (10, 12) }) )
    list.append( ("The craine", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Cripler", "Rammer", { 'radius':1.4, }) )
    list.append( ("The eight ball", "Rammer", { }) )
    list.append( ("Practice target Mid", "Rammer", { 'radius': 1.5, }) )
    list.append( ("Iron Scout", "Poker", { 'nose': math.pi, 'radius':1.4, 'weapons': (9,) }) )
    #list.append( ("Anti-EMERGENCY", "Flipper", { 'radius':1.2, 'nose' : -math.pi / 2, 'car': True, 'topspeed': 12.0, 'turn': 20, 'weapons': (11,) }) )
    list.append( ("Anti-EMERGENCY", "Flipper", { 'radius':1.5, 'nose' : -math.pi / 2, 'topspeed': 12.0, 'turn': 20, 'weapons': (29, 30) }) )
    list.append( ("DJ Ray X MAX", "Rammer", { }) )
    list.append( ("X-Terminator", "Chopper", { 'nose': math.pi, 'weapons': (8,) }) )
    list.append( ("Hazerd Wedge", "Flipper", { 'topspeed' : 12, 'throttle' : 120, 'weapons': (10,) }) )
    list.append( ("Creppler", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'topspeed' : 120.0, 'throttle' : 120, 'weapons' : (10, 12) }) )
    list.append( ("Juggernot", "Flipper", { 'weapons': (15,) }) )
    list.append( ("$P1K3 0 7R0N", "Poker", { 'nose': math.pi, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Big Cash", "Rammer", { }) )
    list.append( ("Takers Raider", "Rammer", { 'turnspeed': 1.5 }) )
    list.append( ("Practice target heavy", "Rammer", { 'invertible': True, }) )
    list.append( ("Kill Blade", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Practice target Light", "Rammer", { }) )
    list.append( ("Smashama", "Rammer", { }) )
    list.append( ("Big-Bite", "Chopper", { 'radius': 1.4, 'topspeed' : 7.0, 'throttle' : 110, 'weapons' : (10, 12) }) )
    list.append( ("Saw force", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 120.0, 'throttle': 110, 'weapons': (21, 22) }) )
    list.append( ("Raptor", "Poker", { 'invertible': True, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("DJ 8", "Rammer", { }) )
    list.append( ("JX-Ripper", "DirectionalSpinner", { 'weapons': (4,) }) )
    list.append( ("Dark Blade", "DirectionalSpinner", { 'topspeed' : 12.0, 'throttle' : 110, 'turnspeed': 1.5, 'weapons': (25, 26) }) )
    list.append( ("Lil Tomb stone", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'topspeed': 190.0, 'turnspeed': 200.0, 'throttle': 190, 'weapons': (21, 22) }) )
    list.append( ("Gruder", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 120.0, 'turnspeed': 150.0, 'throttle': 150, 'weapons': (21, 22) }) )
    list.append( ("Tomb stone", "Poker", { 'nose': math.pi, 'radius':1.4, 'topspeed' : 130.0, 'throttle' : 130, 'weapons': (9,) }) )
    list.append( ("Urbn Kaos", "DirectionalSpinner", { 'invertible': True, 'nose': math.pi, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Vendetta", "Poker", { 'invertible': True, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Thumperizer", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Dementia", "Poker", { 'radius':1.1, 'weapons': (9,) }) )
    list.append( ("All star champ", "Poker", { 'radius':1.1, 'turnspeed' : 1.0, 'turn' : 20.0, 'topspeed' : 12.0, 'throttle' : 120, 'weapons': (9,) }) )
    list.append( ("Madness", "Spinner", { 'nose' : math.pi / 2, 'weapons': (16, 17, 19, 23) }) )
    list.append( ("Old Style Commando", "Rammer", { }) )
