import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)
    
    list.append( ("Wedge", "Flipper", { 'weapons': (14,) }) )
    list.append( ("Black Hawk", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 120.0, 'throttle': 110, 'weapons': (21, 22) }) )
    list.append( ("Attack Plow", "Pusher", { 'radius':1.5, }) )
    list.append( ("Prong", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 120.0, 'throttle': 110, 'weapons': (21, 22) }) )
    list.append( ("Blue Stinger", "Poker", { 'car': True, 'invertible': True, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Axe", "Chopper", { 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Veta Tank", "DirectionalSpinner", { 'invertible': True, 'nose': math.pi, 'trigger' : 'twirl', 'topspeed': 120.0, 'throttle': 110, 'weapons': (21, 22) }) )
    list.append( ("Vanquisher", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 200.0, 'turnspeed': 200.0, 'throttle': 200, 'weapons': (21, 22) }) )
    list.append( ("Shin Dragon", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("SSR-175", "Poker", { 'invertible': True, 'weapons': (21, 22) }) )
    #list.append( ("War Flipper", "Flipper", { 'radius':1.2, 'nose': math.pi, 'weapons': (11,) }) )
    list.append( ("War Flipper", "Flipper", { 'radius':1.5, 'weapons': (29, 30) }) )
    #list.append( ("The craine", "Chopper", { 'weapons' : (10, 12) }) )
    list.append( ("The craine", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Cripler", "Rammer", { 'radius':1.4, }) )
    list.append( ("NSBB [Middle Weight]", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("TKO", "Rammer", { 'nose': math.pi, 'radius': 1.5, }) )
    list.append( ("War Spinner", "DirectionalSpinner", { 'nose': math.pi, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Golden Boy", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Battle Wagon", "Poker", { 'invertible': True, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Zagnut", "Rammer", { 'nose': math.pi, }) )
    list.append( ("Power Sward", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Primal Zombie", "Poker", { 'nose': math.pi, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Frenzy", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Beelzebub", "Poker", { 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Big Cash", "Rammer", { }) )
    list.append( ("Takers Raider", "Rammer", { 'turnspeed': 1.5 }) )
    list.append( ("Hell Miner", "Rammer", { 'nose': math.pi, }) )
    list.append( ("Billy-Bo", "DirectionalSpinner", { 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Mexorb", "Rammer", { 'nose': math.pi, }) )
    list.append( ("Devils'Pet", "Rammer", { 'invertible': True, }) )
    list.append( ("Big-Bite", "Chopper", { 'radius': 1.4, 'topspeed' : 7.0, 'throttle' : 110, 'weapons' : (10, 12) }) )
    list.append( ("Saw force", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 120.0, 'throttle': 110, 'weapons': (21, 22) }) )
    list.append( ("Raptor", "Poker", { 'invertible': True, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Blue Pusher", "Poker", { 'invertible': True, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("JX-Ripper", "DirectionalSpinner", { 'weapons': (4,) }) )
    list.append( ("Dark Stinger", "Rammer", { 'invertible': True, }) )
    list.append( ("Lil Tomb stone", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'topspeed': 190.0, 'turnspeed': 200.0, 'throttle': 190, 'weapons': (21, 22) }) )
    list.append( ("Gruder", "DirectionalSpinner", { 'trigger' : 'twirl', 'topspeed': 120.0, 'turnspeed': 150.0, 'throttle': 150, 'weapons': (21, 22) }) )
    list.append( ("Tomb stone", "Poker", { 'nose': math.pi, 'radius':1.4, 'topspeed' : 130.0, 'throttle' : 130, 'weapons': (9,) }) )
    list.append( ("Ice Pick", "Chopper", { 'radius':1.4, 'topspeed' : 12.0, 'turnspeed': 1.0, 'weapons': (8,) }) )
    list.append( ("Revenger", "Poker", { 'invertible': True, 'radius':1.4, 'weapons': (9,) }) )
    list.append( ("Satan", "Flipper", { 'nose': math.pi, 'radius':1.5, 'weapons': (29, 30) }) )
    list.append( ("NSBB [Light Weight]", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("All star champ", "Poker", { 'radius':1.1, 'turnspeed' : 1.0, 'turn' : 20.0, 'topspeed' : 12.0, 'throttle' : 120, 'weapons': (9,) }) )
    list.append( ("NSBB 2 [Omega]", "DirectionalSpinner", { 'invertible': True, 'trigger' : 'twirl', 'weapons': (21, 22) }) )
    list.append( ("Blue Dannel", "Poker", { 'radius':1.1, 'throttle' : 120, 'weapons': (9,) }) )
