import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 0.0)
    
    list.append( ("Tiny Tank 4.0", "Pusher", { 'topspeed': 15.0, 'throttle': 300, 'turn':80, 'turnspeed':1.5, 'weapons': (13,) }) )
    list.append( ("Trouble from mysterious force", "Whipper", { 'nose' : math.pi, 'invertible': True, 'whip': "around", 'zone': "swing", 'turnspeed':1.5, 'turn':80, 'topspeed':12.0, 'throttle': 110, 'weapons':(14,) }) )
    list.append( ("PokeBot", "Flipper", { 'topspeed' : 9, 'throttle' : 115, 'turn':80, 'weapons': (16, 17) }) )
    list.append( ("Mr. Chaos", "DirectionalSpinner", { 'nose' : math.pi, 'topspeed' : 15.0, 'throttle' : 115, 'turnspeed': 2.0, 'weapons': (16, 17, 18, 19) }) )
    list.append( ("Thunderstorm", "Spinner", { 'radius':6.0, 'topspeed' : 18.0, 'throttle': 200, 'turnspeed': 3.0, 'weapons': (13, 14) }) )
    list.append( ("Stupid Popups...", "Chopper", { 'topspeed' : 15.0, 'throttle' : 110.0, 'weapons': (8, 9, 10) }) )
    list.append( ("Big speaker stereo", "Pusher", { 'radius': 1.4, 'nose' : math.pi , 'topspeed':4.0, 'turnspeed' : 3.5 }) )
    list.append( ("mr. axe", "Spinner", { 'nose' : math.pi, 'radius':1.2, 'turnspeed' : 3.0, 'topspeed' : 20, 'throttle' : 300, 'weapons': (6,) }) )
    list.append( ("Flamer Smasher", "Spinner", { 'nose' : math.pi, 'topspeed' : 12.0 , 'turnspeed' : 1.5 , 'throttle' : 120, 'weapons': (15,) }) )
    list.append( ("Tiny Twist", "Spinner", { 'topspeed' : 8.0, 'turnspeed' : 1.75, 'throttle' : 180 }) )
    list.append( ("Robot Vacumm cleaner", "Spinner", { 'turnspeed' : 1.75, 'throttle' : 300, 'weapons' : (9, 10) }) )
    list.append( ("Flipper king 10.0", "Flipper", { 'nose': math.pi, 'topspeed': 12.0, 'turnspeed': 2.0, 'throttle': 110, 'weapons': (21, 22) }) )
    list.append( ("Stereo", "Pusher", { 'nose' : math.pi , 'turnspeed' : 2.0 }) )
    list.append( ("stds", "Spinner", {  'radius':1.2, 'range' : 10.0, 'topspeed' : 20.0, 'throttle': 300, 'turnspeed' : 4.0, 'weapons': (16, 17, 19, 23) }) )
    list.append( ("Spin Cycle", "Spinner", { 'turnspeed' : 2.5, 'topspeed' : 12, 'weapons': (13,) }) )
    list.append( ("Flip man 2.0", "Flipper", { 'nose' : math.pi, 'radius' : 1.3, 'turnspeed' : 5.0, 'topspeed' : 18.0, 'throttle' : 190, 'weapons' : (1, 2) }) )
    list.append( ("Heavy Lobster", "Chopper", { 'radius':1.5, 'topspeed': 12.0, 'turn': 20, 'weapons': (29, 30) }) )
    list.append( ("Cheesy Pop Up Wedge", "Chopper", { 'radius' : 1.0, 'turnspeed' : 1.5, 'topspeed' : 12.0, 'throttle' : 180, 'weapons': (8,) }) )
    list.append( ("Double Impact", "Spinner", { 'radius':1.1, 'topspeed' : 12.0 , 'turnspeed' : 2.0 , 'throttle' : 120, 'weapons': (8,) }) )
    list.append( ("Metalhead", "Pusher", { 'topspeed' : 12, 'throttle' : 120, 'weapons': (10,) }) )
    list.append( ("4Shadow Force", "Spinner", { 'radius':1.4, 'topspeed' : 12.0, 'turnspeed': 1.0, 'weapons': (8,) }) )
    list.append( ("Wendigo", "Poker", { 'topspeed' : 12.0, 'weapons': (15,) }) )
    list.append( ("The Chaos Engine Version 3", "Spinner", { 'radius':1.2, 'topspeed' : 12 , 'throttle' : 110, 'turnspeed': 1.0, 'weapons': (13, 16) }) )
    list.append( ("Mexican Pizza", "Spinner", { 'topspeed' : 12.0 , 'turnspeed' : 1.25 , 'throttle' : 130, 'weapons': (11,) }) )
    list.append( ("radio", "Rammer", { 'nose': math.pi, 'turnspeed': 1.5 }) )
    list.append( ("Pressure Cooker", "Chopper", { 'turnspeed' : 1.0, 'topspeed' : 12.0, 'weapons': (8, 12) }) )
    list.append( ("ICE Storm", "Spinner", { 'radius':1.2, 'nose' : math.pi, 'turnspeed' : 1.0, 'topspeed' : 12.0, 'throttle' : 120 }) )
    list.append( ("Toaster", "Poker", { 'topspeed' : 12.0, 'throttle' : 120, 'weapons' : (7, 8) }) )
    list.append( ("Power Box 2", "Pusher", { 'topspeed' : 12.0 , 'turnspeed' : 1.75 , 'throttle' : 120, 'weapons': (12,) }) )
    list.append( ("Twister Evolution", "Spinner", { 'radius': 1.4, 'topspeed' : 7.0, 'throttle' : 110, 'weapons' : (10, 12) }) )
    list.append( ("Windstorm", "DirectionalSpinner", { 'nose' : -math.pi / 2, 'turnspeed' : 1.0, 'topspeed' : 12.0, 'throttle' : 120, 'weapons': (7, 8) }) )
    list.append( ("Big Hawk", "Spinner", { 'radius': 1.3, 'topspeed' : 12 , 'throttle' : 110 , 'turnspeed' : 1.25, 'weapons': (14, 15) }) )
    list.append( ("Dirtbox", "Spinner", { 'turnspeed' : 3.0, 'topspeed' : 15.0, 'throttle' : 120, 'weapons': (7, 8) }) )
    list.append( ("Death on spikez", "Pusher", { 'turnspeed' : 1.25, 'topspeed' : 12.0, 'throttle' : 110, 'weapons': (4,) }) )
    list.append( ("Whooping spinner", "DirectionalSpinner", { 'topspeed' : 15.0, 'throttle' : 140, 'turnspeed': 2.0, 'weapons': (25, 26) }) )
    list.append( ("Firestorm", "Flipper", { 'nose': math.pi, 'turnspeed' : 1.0, 'topspeed' : 12.0, 'throttle' : 110, 'weapons' : (4,) }) )
    list.append( ("Spike Spin", "Spinner", { 'nose' : math.pi, 'radius': 1.5, 'invertible': True, 'topspeed' : 18.0, 'throttle' : 300, 'turnspeed' : 3.0, 'weapons' : (2, 3) }) )
    list.append( ("Atomic", "Spinner", { 'nose' : math.pi, 'topspeed' : 12.0, 'throttle' : 110, 'turnspeed' : 1.5, 'weapons': (9, 10) }) )
    list.append( ("Pegesus", "Whipper", { 'nose' : math.pi, 'topspeed' : 12.0, 'throttle' : 140, 'turnspeed': 2.0, 'weapons': (9,) }) )
    list.append( ("I W U C 3.0", "Flipper", { 'nose' : math.pi, 'radius':1.4, 'topspeed' : 22.0, 'throttle' : 300, 'weapons': (99,) }) )
    list.append( ("Striker", "Chopper", { 'radius':1.5, 'turnspeed' : 1.5, 'weapons': (7, 8) }) )
    list.append( ("Half Arse", "Spinner", { 'radius':1.1, 'turnspeed' : 1.0, 'turn' : 20.0, 'topspeed' : 12.0, 'throttle' : 120, 'weapons': (9,) }) )
    list.append( ("Road Block", "Pusher", { 'topspeed' : 12.0, 'throttle' : 125, 'turnspeed' : 1.5, 'weapons': (15, 16) }) )
    list.append( ("smk3", "Spinner", { 'radius':1.2, 'range' : 10.0, 'topspeed' : 20.0, 'throttle': 300, 'turnspeed' : 4.0, 'weapons': (16, 17, 19, 23) }) )
    list.append( ("The Void", "Spinner", { 'radius':1.2, 'turnspeed' : 1.0, 'topspeed' : 20.0, 'throttle' : 300, 'weapons': (18, 19, 20, 21) }) )
