import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)

    # 0 - Team Thunder
    list.append(("Blue Steel","Chopper",{'topspeed':12,'throttle':100,'turn':30,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("The Calling","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,2)}))
    list.append(("Rolling Thunder","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17,18)}))

    # 1 - Team Atari Age
    list.append(("CX100AA","Pusher",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Actiplaque","Chopper",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Heavy Sixer","Chopper",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17)}))

    # 2 - Team Plastic Fruit
    list.append(("Shuv-It","Poker",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Wicked Ride","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17,1,2)}))
    list.append(("Destructo Ray","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':30,'turnspeed':3,'weapons':(16,17,1,2)}))

    # 3 - Team Rambunctious
    list.append(("Sharp Thing","Pusher",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Weed Whacker","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1,2,3,4)}))
    list.append(("Disaster 3000","Spinner",{'topspeed':100,'throttle':80,'turn':25,'turnspeed':3,'weapons':(16,17,1,2,3,4,5,6)}))

    # 4 - Team Morally Wrong
    list.append(("Grandpa's Walker","Pusher",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Glass Breaker","Spinner",{'topspeed':6,'throttle':60,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Totally Offensive","Chopper",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))

    # 5 - Team New Island Technologies
    list.append(("Streamliner II","Pusher",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Infernus II","Chopper",{'invertible':True, 'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Charizard Mk II","Poker",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))

    # 6 - Team DragonWorks
    list.append(("Hatchling","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,18)}))
    list.append(("The Power of Dragons","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1,2,3)}))
    list.append(("Wrath","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17,1,2)}))

    # 7 - Team SWARC
    list.append(("Super Turbo Baby Puncher","Whipper",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Dark Pounder","Pusher",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Dark Micro 44","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))

    # 8 - Team Twilight Foundry
    list.append(("Crash Override Classic","Pusher",{'car':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Crash Override 880","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1,2,3)}))
    list.append(("DURALINER","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17,18)}))

    # 9 - Team gYro
    list.append(("Hypo Gyro","Spinner",{'range':99,'topspeed':100,'throttle':130,'turn':25,'turnspeed':3,'weapons':(16,)}))
    list.append(("Gyro","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Mega Gyro","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1,2,3)}))

    # 10 - Team Robot Faction
    list.append(("Striker Jr","Chopper",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Dead Lift","Chopper",{'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Bad Omen","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1)}))

    # 11 - Team Primal Engineering
    list.append(("Under No Circumstances","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Gaddang!","Chopper",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("The Centrifuge","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))

    # 12 - Team Locomotion
    list.append(("LOCO-motion!","Chopper",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Battering Ram","Rammer",{'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(16,1)}))
    list.append(("Rift Blade","Chopper",{'turn':30,'turnspeed':2.5,'weapons':(16,1)}))

    # 13 - Team NoMercy
    list.append(("Trident","Rammer",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1,2)}))
    list.append(("I Hate The Macarena!!!","Chopper",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Love Me Because I'm Different","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1,2,3)}))

    # 14 - Team Red Alert
    list.append(("Explosion","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1,2)}))
    list.append(("Hammertail","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Fire Wall 2","Rammer",{'invertible':True,'topspeed':100,'throttle':130,'turn':30,'turnspeed':1,'weapons':(16,1,2,3,4,5)}))

    # 15 - Team Radio F Software
    list.append(("Wooden Warrior 6","Spinner",{'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17)}))
    list.append(("The Hacker","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,1)}))
    list.append(("Tha Thumperizer DSL","Spinner",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1,'weapons':(1,2,3,4)}))

    list.append(("Generic","Poker",{'invertible':True,'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
