import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)
    
    # 0 -Spin Doctors "We'll make you a smash hit!"
    list.append(("Tempus Fugit","Spinner",{'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21)}))
    list.append(("Fury","DirectionalSpinner",{'invertible':True,'nose':math.pi/2,'topspeed':12.0,'throttle':115,'turnspeed':3.5,'range':1000000,'weapons':(16,17,18,19,20,21)}))
    list.append(("Maelstrom","DirectionalSpinner",{'invertible':True,'radius':0.5,'topspeed':100,'throttle':120,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))

    # 1 - Alien Invasion "They're here!"
    list.append(("Drone","Rammer",{'invertible':True,'radius':0,'throttle':120,'topspeed':100,'turn':60}))
    list.append(("Praetorian","DirectionalSpinner",{'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21)}))
    list.append(("Alien Queen","DirectionalSpinner",{'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21,22,23)}))

    # 2- The PIT "Paragon Institute of Technology"
    list.append(("Poptart","Flipper",{'invertible':True,'radius':0.5,'nose': math.pi/2,'topspeed':12.0,'weapons':(16,17)}))
    list.append(("WAN Mower","DirectionalSpinner",{'nose':math.pi/2,'radius':0.5,'throttle':120,'topspeed':12,'weapons':(16,17,18)}))
    list.append(("Vortex","Spinner",{'nose':math.pi/2,'topspeed':12.0,'throttle':115,'turnspeed':2.0,'weapons':(16,17,18,19,20,21,23,24)}))

    # 3 - SECOM Security Services "30 years experience in mobile robotics"
    list.append(("Sentinel Observer","Spinner",{'nose':math.pi/2,'radius':0.5,'weapons':(16,17,18)}))
    list.append(("Intruder Alert","Spinner",{'weapons':(16,17,18,19,20,21)}))
    list.append(("Tempest Eliminator","DirectionalSpinner",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25)}))

    # 4 - Three Billy Goats Gruff "We eat anything and everything!"
    list.append(("Billy Goat Gruff","DirectionalSpinner",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':12,'throttle':115,'range':1000000,'weapons':(16,17,18,19)}))
    list.append(("Billy Goat Gruffier","DirectionalSpinner",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21,22,23)}))
    list.append(("Billy Goat Gruffiest","DirectionalSpinner",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'turnspeed':3.0,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))

    # 5 - Orbital Launch Team "How's the view from up there?!"
    list.append(("Sub-Orbital","Flipper",{'radius':0.5,'nose':-math.pi/2,'topspeed':12.0,'turn':60,'turnspeed':2.5,'weapons':(16,17)}))
    list.append(("Launch Platform One","Flipper",{'invertible':True,'radius':0.5,'nose': math.pi/2,'topspeed':12.0,'weapons':(16,17,18,19,20,21)}))
    list.append(("Orbital Delivery Vehicle","DirectionalSpinner",{'turnspeed':1.75,'range':1000000,'weapons':(16,17,18,19,20,21)}))

    # 6 - Team Jabberwocky "'Twas brillig, and the slithy toves, did grye and gimble in the wabe..."
    list.append(("Jubjub Bird","Chopper",{'nose': math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19)}))
    list.append(("Bandersnatch","Chopper",{'nose': math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21,22,23)}))
    list.append(("Jabberwock","Chopper",{'nose': math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40)}))

    # 7 - The Sheep Squad "Baaaaa, Ram, Ewe!"
    list.append(("Battering Lamb","Poker",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11,12,13,14,15)}))
    list.append(("Battering Ewe","Poker",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22)}))
    list.append(("Battering Ram","Poker",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34)}))

    # 8 - SkyNET "Are you Sarah Conner?!"
    list.append(("Aerial HK","Spinner",{'nose':-math.pi/2,'weapons':(16,17,18)}))
    list.append(("T-400 Infiltrator","Spinner",{'nose':math.pi/2,'topspeed':12.0,'throttle':115,'turnspeed':4,'weapons':(16,17,18,19)}))
    list.append(("Hunter-Killer Tank","DirectionalSpinner",{'nose':math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'turnspeed':4.0,'turn':100,'range':1000000,'weapons':(16,17,18,19,20,21,22,23)}))

    # 9 - Borg Collective "We are the Borg. Resistance is futile."
    list.append(("Eagle Borg Scout","Spinner",{'nose':math.pi,'weapons':(16,17,18,19)}))
    list.append(("Borg Drone","Spinner",{'nose':math.pi,'turnspeed':1.5,'weapons':(16,17,18,19,20,21,22,23,24)}))
    list.append(("Borg Queen","Spinner",{'nose':math.pi,'weapons':(16,17,18,19,20,21,22,24,25,26,27,28,29,30,31,32,33,34)}))

    # 10 - Eye of the Storm "We'll tear you apart!"
    list.append(("Cyclone","Spinner",{'nose':-math.pi/2,'weapons':(16,17,18)}))
    list.append(("Hurricane","Spinner",{'nose':-math.pi/2,'weapons':(16,17,18,19,20,21)}))
    list.append(("Jupiter 2","Spinner",{'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))

    # 11 - The Gravediggers "R.I.P. - Rest In Pieces"
    list.append(("Reaper","DirectionalSpinner",{'nose':math.pi/2,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17)}))
    list.append(("Pandora's Box","Poker",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11)}))
    list.append(("Resident Evil","Spinner",{'nose':math.pi/2,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19)}))

    # 12 - King Arthur's Court "Might makes right!"
    list.append(("Castle Guard","Whipper",{'invertible':True,'whip':"around",'radius':1.0,'topspeed':12.0,'throttle':115,'turn':100,'turnspeed':5.0,'weapons':(16,17)}))
    list.append(("Man-at-Arms","DirectionalSpinner",{'invertible':True,'nose':math.pi,'topspeed':12.0,'throttle':115,'turnspeed':3.5,'range':1000000,'weapons':(16,17,18,19,20,21)}))
    list.append(("Lancelot","Poker",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':12,'throttle':110,'turn':100,'turnspeed':4,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20)}))

    # 13 - Team Atlantis "Up from the murky deeps we rise..."
    list.append(("Hydra","Whipper",{'invertible':True,'whip':"around",'nose':-math.pi/2,'radius':1.0,'topspeed':12.0,'throttle':120,'turn':100,'turnspeed':3.0,'weapons':(16,17,18,19)}))
    list.append(("Tentacle Attack","Flipper",{'topspeed':12.0,'throttle':120,'weapons':(16,17,18,19)}))
    list.append(("Kraken","Rammer",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':120,'turnspeed':3.5}))

    # 14 - Acme Moving Men "Look what fell off the truck! Hey, how do you turn this thing on?"
    list.append(("Scrap Box","Rammer",{'invertible':True,'nose':math.pi/2,'radius':0,'throttle':120,'topspeed':100}))
    list.append(("Caution: Hazardous Contents","Rammer",{'invertible':True,'nose':math.pi/2,'radius':0,'throttle':120,'topspeed':100}))
    list.append(("This End Up","Rammer",{'invertible':True,'radius':0,'throttle':120,'topspeed':100}))