import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)

    # 0 - Spin Doctors "We'll make you a smash hit!"
    list.append(("Tempus Fugit","Spinner",{'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21)}))
    list.append(("Fury","DirectionalSpinner",{'invertible':True,'nose':math.pi/2,'topspeed':12.0,'throttle':115,'turnspeed':3.5,'range':1000000,'weapons':(16,17,18,19,20,21)}))
    list.append(("Maelstrom","DirectionalSpinner",{'invertible':True,'radius':0.5,'topspeed':100,'throttle':120,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))
    list.append(("AW-Logic Probe","DirectionalSpinner",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':115,'turnspeed':3.5,'range':1000000,'weapons':(16,)}))
    list.append(("BW-Graviton","Spinner",{'topspeed':12.0,'throttle':115,'weapons':(16,17,18)}))
    list.append(("Matrix Array","Flipper",{'invertible':True,'radius':0.5,'nose':math.pi,'topspeed':12.0,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32)}))

    # 1 - Alien Invasion "They're here!"
    list.append(("Drone","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'turn':40,'turnspeed':1.5}))
    list.append(("Praetorian","Poker",{'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21)}))
    list.append(("Alien Queen","Poker",{'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21,22,23)}))
    list.append(("AW-Chest Burster","Flipper",{'nose':math.pi/2,'radius':0.1,'topspeed':12.0,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("BW-Facehugger","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'turn':20,'turnspeed':1}))
    list.append(("Predator","DirectionalSpinner",{'invertible':True,'topspeed':12.0,'throttle':115,'turnspeed':3.5,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))

    # 2- The PIT "Paragon Institute of Technology"
    list.append(("Poptart","Flipper",{'radius':0.5,'nose':math.pi/2,'topspeed':12.0,'weapons':(16,17)}))
    list.append(("WAN Mower","DirectionalSpinner",{'nose':math.pi/2,'radius':0.5,'throttle':120,'topspeed':12,'weapons':(16,17,18)}))
    list.append(("Vortex","Spinner",{'nose':math.pi/2,'topspeed':12.0,'throttle':115,'turnspeed':2.0,'weapons':(16,17,18,19,20,21,23,24)}))
    list.append(("AW-VR Rino","Rammer",{'invertible':True,'nose':math.pi/2,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Bird of Prey","Spinner",{'nose':-math.pi/2,'weapons':(16,17,18)}))
    list.append(("Pitbull","DirectionalSpinner",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':115,'turnspeed':3.0,'range':1000000,'weapons':(16,17,18,19,20,21,22,23)}))

    # 3 - SECOM Security Services "30 years experience in mobile robotics"
    list.append(("Sentinel Observer","Spinner",{'nose':math.pi/2,'radius':0.5,'weapons':(16,17,18)}))
    list.append(("Intruder Alert","Spinner",{'weapons':(16,17,18,19,20,21)}))
    list.append(("Tempest Eliminator","DirectionalSpinner",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25)}))
    list.append(("AW-Halt, who goes there?","Whipper",{'invertible':True,'nose':math.pi,'whip':"around",'radius':0.1,'topspeed':12.0,'throttle':115,'turn':100,'turnspeed':5,'weapons':(16,)}))
    list.append(("BW-None Shall Pass","Whipper",{'invertible':True,'whip':"around",'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':115,'turn':100,'turnspeed':5,'weapons':(16,)}))
    list.append(("Lethal Force","Poker",{'invertible':True,'radius':0.1,'topspeed':12,'throttle':110,'weapons':(9,10,11,12,13,14,15,16,17,18)}))

    # 4 - Three Billy Goats Gruff "We eat anything and everything!"
    list.append(("Billy Goat Gruff","DirectionalSpinner",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':12,'throttle':115,'range':1000000,'weapons':(16,17,18,19)}))
    list.append(("Billy Goat Gruffier","DirectionalSpinner",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21,22,23)}))
    list.append(("Billy Goat Gruffiest","DirectionalSpinner",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'turn':40,'turnspeed':2.0,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))
    list.append(("AW-Billy the Kid","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Billy Goat Gruffy","DirectionalSpinner",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':12,'throttle':115,'range':1000000,'weapons':(16,17)}))
    list.append(("The Troll","DirectionalSpinner",{'invertible':True,'nose':-math.pi/2,'radius':0.5,'topspeed':100,'throttle':120,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))
   
    # 5 - Orbital Launch Team "How's the view from up there?!"
    list.append(("Sub-Orbital","Flipper",{'radius':0.5,'nose':-math.pi/2,'topspeed':12.0,'turn':60,'turnspeed':2.5,'weapons':(16,17)}))
    list.append(("Launch Platform One","Flipper",{'radius':0.5,'nose': math.pi/2,'topspeed':12.0,'weapons':(16,17,18,19,20,21)}))
    list.append(("Orbital Delivery Vehicle","Poker",{'turnspeed':1.75,'range':1000000,'weapons':(16,17,18,19,20,21)}))
    list.append(("AW-Launch Platform Zero","Flipper",{'radius':0.1,'nose':math.pi,'topspeed':12.0,'weapons':(16,)}))
    list.append(("BW-Stratosphere","Flipper",{'nose':math.pi/2,'radius':0.1,'topspeed':12.0,'weapons':(16,17)}))
    list.append(("3-2-1 Blastoff!","Flipper",{'radius':0.5,'nose': math.pi/2,'topspeed':12.0,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))

    # 6 - Team Jabberwocky "'Twas brillig, and the slithy toves, did grye and gimble in the wabe..."
    list.append(("Jubjub Bird","Chopper",{'nose': math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19)}))
    list.append(("Bandersnatch","Chopper",{'nose': math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21,22,23)}))
    list.append(("Jabberwock","Chopper",{'invertible':True,'nose': math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40)}))
    list.append(("AW-Vorpal Bunny","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Slithy Tove","Chopper",{'radius':0.5,'topspeed':12.0,'throttle':115,'weapons':(16,17)}))
    list.append(("Borogove","Chopper",{'invertible':True,'nose': math.pi,'radius':1,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))

    # 7 - The Sheep Squad "Baaaaa, Ram, Ewe!"
    list.append(("Battering Lamb","Poker",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11,12,13,14,15)}))
    list.append(("Battering Ewe","Poker",{'invertible':True,'nose':math.pi,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22)}))
    list.append(("Battering Ram","Poker",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34)}))
    list.append(("AW-The Shepard","Pusher",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Wolf in Sheep's Clothing","Poker",{'invertible':True,'radius':0.1,'topspeed':12.0,'throttle':120,'weapons':(9,10)}))
    list.append(("Baa Baa Black Sheep","Flipper",{'nose': math.pi,'topspeed':12.0,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))

    # 8 - SkyNET "Are you Sarah Conner?!"
    list.append(("Aerial HK","Spinner",{'nose':-math.pi/2,'weapons':(16,17,18)}))
    list.append(("T-400 Infiltrator","Flipper",{'nose':-math.pi/2,'topspeed':12.0,'throttle':115,'turnspeed':4,'weapons':(16,17,18,19)}))
    list.append(("Hunter-Killer Tank","DirectionalSpinner",{'nose':math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'turnspeed':4.0,'turn':100,'range':1000000,'weapons':(16,17,18,19,20,21,22,23)}))
    list.append(("AW-T-125 Burger Flipper","Flipper",{'radius':0.1,'topspeed':12.0,'turn':60,'turnspeed':2.5,'weapons':(16,17)}))
    list.append(("BW-Mini-Hunter","Spinner",{'topspeed':12.0,'throttle':115,'weapons':(16,17,18)}))
    list.append(("T-800 Terminator","DirectionalSpinner",{'invertible':True,'radius':1,'topspeed':12.0,'throttle':115,'turn':100,'turnspeed':3.0,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39)}))

    # 9 - Borg Collective "We are the Borg. Resistance is futile."
    list.append(("Eagle Borg Scout","Spinner",{'nose':math.pi,'weapons':(16,17,18,19)}))
    list.append(("Borg Drone","Spinner",{'nose':math.pi,'turnspeed':1.5,'weapons':(16,17,18,19,20,21,22,23,24)}))
    list.append(("Borg Queen","Spinner",{'nose':math.pi,'weapons':(16,17,18,19,20,21,22,24,25,26,27,28,29,30,31,32,33,34)}))
    list.append(("AW-Borgette","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Gravitic Mine","Spinner",{'weapons':(16,17)}))
    list.append(("Locutus","Flipper",{'radius':1.5,'nose': -math.pi/2,'topspeed':12.0,'weapons':(16,17,18,19,20,21,22,23)}))

    # 10 - Eye of the Storm "We'll tear you apart!"
    list.append(("Cyclone","Spinner",{'nose':-math.pi/2,'weapons':(16,17,18)}))
    list.append(("Hurricane","Spinner",{'nose':-math.pi/2,'weapons':(16,17,18,19,20,21)}))
    list.append(("Jupiter 2","Spinner",{'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))
    list.append(("AW-Whirlwind","DirectionalSpinner",{'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,)}))
    list.append(("BW-Tsunami","Pusher",{'invertible':True,'radius':0,'turn':30,'turnspeed':1.0,'throttle':120,'topspeed':100}))
    list.append(("Tidalwave","DirectionalSpinner",{'nose':-math.pi/2,'radius':0.5,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39)}))

    # 11 - The Gravediggers "R.I.P. - Rest In Pieces"
    list.append(("Reaper","DirectionalSpinner",{'nose':math.pi/2,'topspeed':12.0,'throttle':115,'range':1000000,'weapons':(16,17)}))
    list.append(("Pandora's Box","Poker",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11)}))
    list.append(("Resident Evil","Spinner",{'nose':math.pi/2,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19)}))
    list.append(("AW-Zombie","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Ghoul","Flipper",{'radius':0.5,'topspeed':12.0,'weapons':(16,)}))
    list.append(("Wraith","DirectionalSpinner",{'invertible':True,'radius':0.5,'topspeed':100,'throttle':120,'range':1000000,'weapons':(16,17,18,19)}))

    # 12 - King Arthur's Court "Might makes right!"
    list.append(("Castle Guard","Whipper",{'invertible':True,'whip':"around",'radius':1.0,'topspeed':12.0,'throttle':115,'turn':100,'turnspeed':5.0,'weapons':(16,)}))
    list.append(("Man-at-Arms","DirectionalSpinner",{'invertible':True,'nose':math.pi,'topspeed':12.0,'throttle':115,'turnspeed':3.5,'range':1000000,'weapons':(16,17,18,19,20,21)}))
    list.append(("Lancelot","Poker",{'invertible':True,'nose':math.pi/2,'radius':0.5,'topspeed':12,'throttle':110,'turn':100,'turnspeed':4,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20)}))
    list.append(("AW-BattleANT","Whipper",{'invertible':True,'whip':"around",'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':115,'turn':100,'turnspeed':5.0,'weapons':(16,17)}))
    list.append(("BW-Squire","Poker",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':120,'weapons':(9,)}))
    list.append(("Black Knight","Poker",{'invertible':True,'range':1000000,'throttle':120,'topspeed':100,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24)}))

    # 13 - Team Atlantis "Up from the murky deeps we rise..."
    list.append(("Hydra","Whipper",{'invertible':True,'whip':"around",'nose':-math.pi/2,'radius':0.1,'topspeed':12.0,'throttle':120,'turn':100,'turnspeed':3.0,'weapons':(16,17,18,19)}))
    list.append(("Tentacle Attack","Flipper",{'topspeed':12.0,'throttle':120,'weapons':(16,17,18,19)}))
    list.append(("Kraken","Poker",{'invertible':True,'radius':0.5,'topspeed':12.0,'throttle':120,'weapons':(9,10,11,12,13,14,15,16,17,18)}))
    list.append(("AW-Riptide","Rammer",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':120}))
    list.append(("BW-Piranha","Poker",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':120,'weapons':(9,10)}))
    list.append(("Leviathan","Chopper",{'invertible':True,'topspeed':12.0,'throttle':115,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31)}))

    # 14 - Acme Moving Men "Look what fell off the truck! Hey, how do you turn this thing on?"
    list.append(("Scrap Box","Rammer",{'invertible':True,'nose':math.pi/2,'radius':0.1,'throttle':120,'topspeed':100,'turn':30,'turnspeed':1.5}))
    list.append(("Caution: Hazardous Contents","Rammer",{'invertible':True,'nose':math.pi/2,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("This End Up","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("AW-Wooden Box on a Stick","Rammer",{'invertible':True,'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Nail Gun","Rammer",{'invertible':True,'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'turn':10,'turnspeed':1.5}))
    list.append(("Battlebox","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))

    # 15 - Rust Factory "Brought to you by Rejected"
    list.append(("Reckless Infiltrator","Poker",{'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10,11,12,13,14)}))
    list.append(("Acrid","Poker",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10,11,12,13,14)}))
    list.append(("Clockwork Hydra","Poker",{'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24)}))
    list.append(("AW-Expendable Automation","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Offensive Sentry","Spinner",{'nose':math.pi,'topspeed':12.0,'throttle':120,'weapons':(16,17,18)}))
    list.append(("Mechanical Waterbug","Poker",{'topspeed':12.0,'throttle':120,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35)}))

    # 16 - Grandpa's Shed "Brought to you by Clutch"
    list.append(("Particle Man","Flipper",{'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10,11)}))
    list.append(("Bucket of Nails","Spinner",{'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10,11,12,13,14,15,16,17,18,19,20)}))
    list.append(("Old Rusty Lawn Mower","DirectionalSpinner",{'range':1000000,'throttle':120,'topspeed':100,'weapons':(9,10,11,12,13,14,15,16)}))
    list.append(("AW-Old Tin Can","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Tiny Tetanus","Poker",{'nose':math.pi,'radius':0.1,'topspeed':12.0,'throttle':120,'weapons':(16,17,18)}))
    list.append(("Shedenator","Flipper",{'nose':math.pi,'topspeed':12.0,'throttle':120,'weapons':(16,17,18,19,20,21,22,23,24,25,26,27)}))

    # 17 - ACAMS Cleaning Service "Brought to you by ACAMS"
    list.append(("Duster","Chopper",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10,11,12)}))
    list.append(("Sweeper","Chopper",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10,11,12,13,14,15,16)}))
    list.append(("Street Sweeper","Chopper",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32)}))
    list.append(("AW-Wisk Broom","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Scrubber","Chopper",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10)}))
    list.append(("Sanitizer","DirectionalSpinner",{'invertible':True,'range':1000000,'throttle':120,'topspeed':100,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24)}))

    # 18 - Spam! Spam! Spam! "Brought to you by Diablo"
    list.append(("Click Me!","Flipper",{'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,10)}))
    list.append(("Win! Win! WIN!","Flipper",{'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'turn':30,'turnspeed':2,'weapons':(9,10)}))
    list.append(("The Spaminator","Flipper",{'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'turn':30,'turnspeed':2,'weapons':(9,10,11,12)}))
    list.append(("AW-Viagra-R-Us","Flipper",{'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,)}))
    list.append(("BW-Lose Weight!","Flipper",{'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,)}))
    list.append(("Ultimate Spammer","Poker",{'nose':math.pi,'radius':0.1,'throttle':120,'topspeed':100,'turn':30,'turnspeed':2,'weapons':(9,10,11,12,13,14,15)}))

    # 19 - 1337 5P33|<3R5 "Brought to you by Eyce"
    list.append(("Uber-1337","Spinner",{'topspeed':12.0,'throttle':120,'weapons':(16,17,18,19,20,21)}))
    list.append(("n00b","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'turn':30,'turnspeed':2}))
    list.append(("1337 Speek","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'turn':30,'turnspeed':2}))
    list.append(("AW-IBK-Idiot Behind Keyboard","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100}))
    list.append(("BW-Lil' 1337","Flipper",{'radius':0.1,'throttle':120,'topspeed':100,'weapons':(9,)}))
    list.append(("133+  5P34K Original","Rammer",{'invertible':True,'radius':0.1,'throttle':120,'topspeed':100,'turn':30,'turnspeed':2}))